/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AcknowledgementQueue;
import io.atleon.core.Alo;
import io.atleon.core.AloQueueingSubscriber;
import io.atleon.core.OrderManagingAcknowledgementQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class OrderManagingAcknowledgementOperator<T, A extends Alo<T>>
implements Publisher<Alo<T>> {
    private final Publisher<? extends A> source;
    private final Function<T, ?> groupExtractor;
    private final long maxInFlight;

    public OrderManagingAcknowledgementOperator(Publisher<? extends A> source, Function<T, ?> groupExtractor) {
        this(source, groupExtractor, Long.MAX_VALUE);
    }

    public OrderManagingAcknowledgementOperator(Publisher<? extends A> source, Function<T, ?> groupExtractor, long maxInFlight) {
        this.source = source;
        this.groupExtractor = groupExtractor;
        this.maxInFlight = maxInFlight;
    }

    public void subscribe(Subscriber<? super Alo<T>> actual) {
        this.source.subscribe(new AloQueueingSubscriber(actual, this.groupExtractor, OrderManagingAcknowledgementOperator.newQueueSupplier(), this.maxInFlight));
    }

    private static Supplier<AcknowledgementQueue> newQueueSupplier() {
        return OrderManagingAcknowledgementQueue::create;
    }
}

