/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import java.util.function.BiPredicate;
import reactor.core.publisher.SynchronousSink;

interface AloFailureStrategy {
    public static final AloFailureStrategy EMIT = new Emit((__, error) -> true);
    public static final AloFailureStrategy DELEGATE = new Delegate((__, error) -> true);

    public boolean process(SynchronousSink<?> var1, Alo<?> var2, Throwable var3);

    public static AloFailureStrategy emit() {
        return EMIT;
    }

    public static AloFailureStrategy emit(BiPredicate<Object, ? super Throwable> errorPredicate) {
        return new Emit(errorPredicate);
    }

    public static AloFailureStrategy delegate() {
        return DELEGATE;
    }

    public static AloFailureStrategy delegate(BiPredicate<Object, ? super Throwable> errorPredicate) {
        return new Delegate(errorPredicate);
    }

    public static class Delegate
    implements AloFailureStrategy {
        private final BiPredicate<Object, ? super Throwable> errorPredicate;

        Delegate(BiPredicate<Object, ? super Throwable> errorPredicate) {
            this.errorPredicate = errorPredicate;
        }

        @Override
        public boolean process(SynchronousSink<?> sink, Alo<?> alo, Throwable error) {
            if (this.errorPredicate.test(alo.get(), error)) {
                return false;
            }
            Alo.acknowledge(alo);
            return true;
        }
    }

    public static class Emit
    implements AloFailureStrategy {
        private final BiPredicate<Object, ? super Throwable> errorPredicate;

        Emit(BiPredicate<Object, ? super Throwable> errorPredicate) {
            this.errorPredicate = errorPredicate;
        }

        @Override
        public boolean process(SynchronousSink<?> sink, Alo<?> alo, Throwable error) {
            if (this.errorPredicate.test(alo.get(), error)) {
                sink.error(error);
            } else {
                Alo.acknowledge(alo);
            }
            return true;
        }
    }
}

