/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class AcknowledgementQueue {
    private static final AtomicIntegerFieldUpdater<AcknowledgementQueue> DRAINS_IN_PROGRESS = AtomicIntegerFieldUpdater.newUpdater(AcknowledgementQueue.class, "drainsInProgress");
    protected final Queue<InFlight> queue = new ConcurrentLinkedQueue<InFlight>();
    private volatile int drainsInProgress;

    AcknowledgementQueue() {
    }

    public InFlight add(Runnable acknowledger, Consumer<? super Throwable> nacknowledger) {
        InFlight inFlight = new InFlight(acknowledger, nacknowledger);
        this.queue.add(inFlight);
        return inFlight;
    }

    public long complete(InFlight toComplete) {
        return this.complete(toComplete, rec$ -> ((InFlight)rec$).complete()) ? this.drain() : 0L;
    }

    public long completeExceptionally(InFlight toComplete, Throwable error) {
        return this.complete(toComplete, inFlight -> ((InFlight)inFlight).completeExceptionally(error)) ? this.drain() : 0L;
    }

    protected abstract boolean complete(InFlight var1, Function<InFlight, Boolean> var2);

    private long drain() {
        if (DRAINS_IN_PROGRESS.getAndIncrement(this) != 0) {
            return 0L;
        }
        long drained = 0L;
        int missed = 1;
        while (true) {
            if (!this.queue.isEmpty() && !this.queue.peek().isInProcess()) {
                this.queue.remove().execute();
                ++drained;
                continue;
            }
            if ((missed = DRAINS_IN_PROGRESS.addAndGet(this, -missed)) == 0) break;
        }
        return drained;
    }

    static final class InFlight {
        private static final AtomicReferenceFieldUpdater<InFlight, State> STATE = AtomicReferenceFieldUpdater.newUpdater(InFlight.class, State.class, "state");
        private final Runnable acknowledger;
        private final Consumer<? super Throwable> nacknowledger;
        private volatile State state = State.IN_PROCESS;
        private Throwable error;

        private InFlight(Runnable acknowledger, Consumer<? super Throwable> nacknowledger) {
            this.acknowledger = acknowledger;
            this.nacknowledger = nacknowledger;
        }

        boolean isInProcess() {
            return this.state == State.IN_PROCESS;
        }

        private boolean complete() {
            return STATE.compareAndSet(this, State.IN_PROCESS, State.COMPLETED);
        }

        private boolean completeExceptionally(Throwable error) {
            boolean completed = STATE.compareAndSet(this, State.IN_PROCESS, State.COMPLETED);
            if (completed) {
                this.error = error;
            }
            return completed;
        }

        private void execute() {
            if (STATE.getAndSet(this, State.EXECUTED) != State.EXECUTED) {
                this.executeAcknowledgement();
            }
        }

        private void executeAcknowledgement() {
            if (this.error == null) {
                this.acknowledger.run();
            } else {
                this.nacknowledger.accept(this.error);
            }
        }

        private static enum State {
            IN_PROCESS,
            COMPLETED,
            EXECUTED;

        }
    }
}

