/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ActivityEnforcementConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ActivityEnforcingTransformer<T>
implements Function<Publisher<T>, Publisher<T>> {
    private final ActivityEnforcementConfig config;

    ActivityEnforcingTransformer(ActivityEnforcementConfig config) {
        this.config = config;
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        return this.config.isEnabled() ? Flux.from(publisher).transformDeferred(this::enforceActivity) : publisher;
    }

    private Flux<T> enforceActivity(Publisher<T> publisher) {
        AtomicReference<Instant> lastActive = new AtomicReference<Instant>(Instant.now());
        Publisher[] publisherArray = new Publisher[2];
        publisherArray[0] = this.createInactivityError(lastActive::get);
        publisherArray[1] = publisher;
        return Flux.merge((Publisher[])publisherArray).doOnEach(signal -> lastActive.set(Instant.now()));
    }

    private Mono<T> createInactivityError(Supplier<Instant> lastActive) {
        return Flux.interval((Duration)this.config.getDelay(), (Duration)this.config.getInterval()).map(i -> (Instant)lastActive.get()).filter(this::hasBecomeInactiveSince).next().flatMap(this::createInactivityError);
    }

    private boolean hasBecomeInactiveSince(Instant lastActive) {
        return this.config.getMaxInactivity().compareTo(Duration.between(lastActive, Instant.now())) < 0;
    }

    private Mono<T> createInactivityError(Instant lastActive) {
        return Mono.error((Throwable)new InactiveStreamException(this.config.getName(), this.config.getMaxInactivity(), lastActive));
    }

    private static final class InactiveStreamException
    extends TimeoutException {
        public InactiveStreamException(String name, Duration maxInactivity, Instant lastActive) {
            super(String.format("Stream=%s has been inactive for longer than duration=%s with lastActive=%s", name, maxInactivity, lastActive));
        }
    }
}

