/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ConditionallyRandomizedConfigs;
import io.atleon.core.ConfigInterceptor;
import io.atleon.core.EnvironmentalConfigs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class ConfigProvider<T, P extends ConfigProvider<T, P>> {
    private Map<String, Object> properties = Collections.emptyMap();
    private Function<Map<String, Object>, Optional<String>> propertiesToName;

    protected ConfigProvider() {
        this((Map<String, Object> properties) -> Optional.empty());
    }

    protected ConfigProvider(String name) {
        this((Map<String, Object> properties) -> Optional.of(name));
    }

    protected ConfigProvider(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        this.propertiesToName = propertiesToName;
    }

    public final T create() {
        return (T)this.propertiesToName.apply(this.properties).map(name -> this.create((String)name, this.properties)).orElseGet(() -> this.create(this.properties));
    }

    public final P rename(String name) {
        P copy = this.copy();
        ((ConfigProvider)copy).setPropertiesToName(properties -> Optional.of(name));
        return copy;
    }

    public P with(String key, Object value) {
        HashMap<String, Object> copiedProperties = new HashMap<String, Object>(this.properties);
        copiedProperties.put(key, value);
        P copy = this.copy();
        ((ConfigProvider)copy).setProperties(Collections.unmodifiableMap(copiedProperties));
        return copy;
    }

    public P withAll(Map<String, ?> properties) {
        HashMap<String, Object> copiedProperties = new HashMap<String, Object>(this.properties);
        copiedProperties.putAll(properties);
        P copy = this.copy();
        ((ConfigProvider)copy).setProperties(Collections.unmodifiableMap(copiedProperties));
        return copy;
    }

    protected abstract T create(String var1, Map<String, Object> var2);

    protected abstract T create(Map<String, Object> var1);

    protected final P copy() {
        P copy = this.initializeCopy();
        ((ConfigProvider)copy).setProperties(this.properties);
        ((ConfigProvider)copy).setPropertiesToName(this.propertiesToName);
        return copy;
    }

    protected abstract P initializeCopy();

    protected Collection<ConfigInterceptor> defaultInterceptors() {
        return Arrays.asList(new EnvironmentalConfigs(), new ConditionallyRandomizedConfigs());
    }

    protected static void validateNonNullProperty(Map<String, Object> properties, String key) {
        Objects.requireNonNull(properties.get(key), key + " is a required Configuration");
    }

    protected static <T extends Enum<T>> void validateEnumProperty(Map<String, Object> properties, String key, Class<T> enumClass) {
        try {
            Enum.valueOf(enumClass, Objects.toString(properties.get(key)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(key + " must be configured as an Enum value from " + enumClass, e);
        }
    }

    final void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    final void setPropertiesToName(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        this.propertiesToName = propertiesToName;
    }
}

