/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ConfigInterceptor;
import io.atleon.core.ConfigProcessor;
import io.atleon.core.ConfigProvider;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Instantiation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public abstract class ConfigSource<T, S extends ConfigSource<T, S>>
extends ConfigProvider<Mono<T>, S> {
    public static final String PROCESSORS_PROPERTY = "source.processors";
    private Function<Map<String, Object>, Optional<String>> propertiesToName;

    protected ConfigSource() {
        this((Map<String, Object> properties) -> Optional.empty());
    }

    protected ConfigSource(String name) {
        this((Map<String, Object> properties) -> Optional.of(name));
    }

    protected ConfigSource(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        this.propertiesToName = propertiesToName;
    }

    @Override
    public final Mono<T> create(Map<String, Object> properties) {
        return this.applyProcessors(properties).doOnNext(this::validateProperties).map(this::postProcessProperties);
    }

    @Override
    protected final S initializeProviderCopy() {
        S copy = this.initializeSourceCopy();
        ((ConfigSource)copy).setPropertiesToName(this.propertiesToName);
        return copy;
    }

    protected abstract S initializeSourceCopy();

    protected abstract void validateProperties(Map<String, Object> var1);

    protected abstract T postProcessProperties(Map<String, Object> var1);

    protected Mono<Map<String, Object>> applyProcessors(Map<String, Object> properties) {
        Optional<String> nameFromProperties = this.propertiesToName.apply(properties);
        Mono result = Mono.just(properties);
        for (ConfigProcessor processor : this.loadProcessors(properties)) {
            result = result.flatMap(configs -> nameFromProperties.map(name -> processor.process((String)name, (Map<String, Object>)configs)).orElseGet(() -> processor.process((Map<String, Object>)configs)));
        }
        return result;
    }

    protected List<ConfigProcessor> loadProcessors(Map<String, Object> properties) {
        List<ConfigProcessor> processors = this.defaultInterceptors().stream().map(ConfigInterceptor::asProcessor).collect(Collectors.toList());
        processors.addAll(ConfigLoading.loadListOrEmpty(properties, (String)PROCESSORS_PROPERTY, x$0 -> (ConfigProcessor)Instantiation.one((String)x$0, (Object[])new Object[0])));
        return processors;
    }

    protected void setPropertiesToName(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        this.propertiesToName = propertiesToName;
    }
}

