/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AcknowledgingCollection;
import io.atleon.core.AcknowledgingPublisher;
import io.atleon.core.Alo;
import io.atleon.core.AloFactory;
import io.atleon.core.AloOps;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public abstract class AbstractAlo<T>
implements Alo<T> {
    @Override
    public boolean filter(Predicate<? super T> predicate, Consumer<? super Alo<T>> negativeConsumer) {
        boolean result = predicate.test(this.get());
        if (!result) {
            negativeConsumer.accept(this);
        }
        return result;
    }

    @Override
    public <R, C extends Collection<R>> Collection<Alo<R>> mapToMany(Function<? super T, ? extends C> mapper, Consumer<? super Alo<T>> emptyMappingConsumer) {
        Collection collection = (Collection)mapper.apply(this.get());
        if (collection.isEmpty()) {
            emptyMappingConsumer.accept(this);
        }
        return collection.isEmpty() ? Collections.emptyList() : new AcknowledgingCollection<R>(collection, this.getAcknowledger(), this.getNacknowledger(), this.createPropagator());
    }

    @Override
    public <R> Alo<R> map(Function<? super T, ? extends R> mapper) {
        return this.propagate(mapper.apply(this.get()), this.getAcknowledger(), this.getNacknowledger());
    }

    @Override
    public <R, P extends Publisher<R>> Publisher<Alo<R>> publish(Function<? super T, ? extends P> mapper) {
        return new AcknowledgingPublisher<R>((Publisher)mapper.apply(this.get()), this.getAcknowledger(), this.getNacknowledger(), this.createPropagator());
    }

    @Override
    public Alo<T> reduce(BinaryOperator<T> reducer, Alo<? extends T> other) {
        return this.propagate(reducer.apply(this.get(), other.get()), AloOps.combineAcknowledgers(this.getAcknowledger(), other.getAcknowledger()), AloOps.combineNacknowledgers(this.getNacknowledger(), other.getNacknowledger()));
    }

    @Override
    public void consume(Consumer<? super T> consumer, Consumer<? super Alo<T>> andThen) {
        consumer.accept(this.get());
        andThen.accept(this);
    }

    @Override
    public final <R> Alo<R> propagate(R result, Runnable acknowledger, Consumer<? super Throwable> nacknowledger) {
        return this.createPropagator().create(result, acknowledger, nacknowledger);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.get() + ")";
    }

    protected abstract <R> AloFactory<R> createPropagator();
}

