/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.util;

import io.atleon.util.ConfigLoading;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public final class AwsConfig {
    public static final String CONFIG_PREFIX = "aws.";
    public static final String CREDENTIALS_PROVIDER_TYPE_CONFIG = "aws.credentials.provider.type";
    public static final String CREDENTIALS_PROVIDER_TYPE_DEFAULT = "default";
    public static final String CREDENTIALS_PROVIDER_TYPE_STATIC = "static";
    public static final String CREDENTIALS_TYPE_CONFIG = "aws.credentials.type";
    public static final String CREDENTIALS_TYPE_BASIC = "basic";
    public static final String CREDENTIALS_TYPE_SESSION = "session";
    public static final String CREDENTIALS_ACCESS_KEY_ID_CONFIG = "aws.credentials.access.key.id";
    public static final String CREDENTIALS_SECRET_ACCESS_KEY_CONFIG = "aws.credentials.secret.access.key";
    public static final String CREDENTIALS_SESSION_TOKEN_CONFIG = "aws.credentials.session.token";
    public static final String REGION_CONFIG = "aws.region";

    private AwsConfig() {
    }

    public static AwsCredentialsProvider loadCredentialsProvider(Map<String, ?> configs) {
        String type;
        switch (type = ConfigLoading.loadString(configs, (String)CREDENTIALS_PROVIDER_TYPE_CONFIG).orElse(CREDENTIALS_PROVIDER_TYPE_DEFAULT)) {
            case "default": {
                return DefaultCredentialsProvider.create();
            }
            case "static": {
                return StaticCredentialsProvider.create((AwsCredentials)AwsConfig.loadAwsCredentials(configs));
            }
        }
        throw new IllegalArgumentException("Cannot create AwsCredentialsProvider for type=" + type);
    }

    public static AwsCredentials loadAwsCredentials(Map<String, ?> configs) {
        String type;
        switch (type = ConfigLoading.loadString(configs, (String)CREDENTIALS_TYPE_CONFIG).orElse(CREDENTIALS_TYPE_BASIC)) {
            case "basic": {
                return AwsBasicCredentials.create((String)ConfigLoading.loadStringOrThrow(configs, (String)CREDENTIALS_ACCESS_KEY_ID_CONFIG), (String)ConfigLoading.loadStringOrThrow(configs, (String)CREDENTIALS_SECRET_ACCESS_KEY_CONFIG));
            }
            case "session": {
                return AwsSessionCredentials.create((String)ConfigLoading.loadStringOrThrow(configs, (String)CREDENTIALS_ACCESS_KEY_ID_CONFIG), (String)ConfigLoading.loadStringOrThrow(configs, (String)CREDENTIALS_SECRET_ACCESS_KEY_CONFIG), (String)ConfigLoading.loadStringOrThrow(configs, (String)CREDENTIALS_SESSION_TOKEN_CONFIG));
            }
        }
        throw new IllegalArgumentException("Cannot create AwsCredentials for type=" + type);
    }

    public static Optional<Region> loadRegion(Map<String, ?> configs) {
        return ConfigLoading.loadParseable(configs, (String)REGION_CONFIG, Region.class, Region::of);
    }
}

