/*
 * Decompiled with CFR 0.152.
 */
package io.atlassian.fugue.hamcrest;

import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class OptionMatchers {
    private OptionMatchers() {
        throw new UnsupportedOperationException();
    }

    public static <L> Matcher<Option<?>> isNone() {
        return NoneMatcher.INSTANCE;
    }

    public static <T> Matcher<Option<T>> isSome(Matcher<? super T> subMatcher) {
        return new SomeMatcher(Objects.requireNonNull(subMatcher, "subMatcher"));
    }

    private static class SomeMatcher<T>
    extends TypeSafeMatcher<Option<T>> {
        private final Matcher<? super T> subMatcher;

        private SomeMatcher(Matcher<? super T> subMatcher) {
            this.subMatcher = subMatcher;
        }

        protected boolean matchesSafely(Option<T> actual) {
            return actual.exists(arg_0 -> this.subMatcher.matches(arg_0));
        }

        public void describeTo(Description description) {
            description.appendText("some that ");
            this.subMatcher.describeTo(description);
        }

        protected void describeMismatchSafely(Option<T> actual, Description mismatchDescription) {
            actual.fold(() -> {
                mismatchDescription.appendText("was none");
                return Unit.Unit();
            }, item -> {
                mismatchDescription.appendText("was some that ");
                this.subMatcher.describeMismatch(item, mismatchDescription);
                return Unit.Unit();
            });
        }
    }

    private static class NoneMatcher
    extends TypeSafeMatcher<Option<?>> {
        private static final Matcher<Option<?>> INSTANCE = new NoneMatcher();

        private NoneMatcher() {
        }

        protected boolean matchesSafely(Option<?> actual) {
            return actual.isEmpty();
        }

        public void describeTo(Description description) {
            description.appendText("none");
        }

        protected void describeMismatchSafely(Option<?> actual, Description mismatchDescription) {
            actual.forEach(item -> mismatchDescription.appendText("was some"));
        }
    }
}

