package io.atlassian.blobstore.client.api;

/**
 * The result of a put operation call on a BlobstoreService
 */
public class PutResult {

  public static PutResult updated(String hash) {
    return new PutResult(Status.UPDATED, hash);
  }

  public static PutResult created(String hash) {
    return new PutResult(Status.CREATED, hash);
  }

  private final Status status;
  private final String hash;

  PutResult(Status status, String hash) {
    this.status = status;
    this.hash = hash;
  }

  public String hash() {
    return hash;
  }

  public Status status() {
    return status;
  }

  public static enum Status {
    CREATED, UPDATED
  }
}
