package io.atlassian.blobstore.client.api;

/**
 * The result of a head operation call on a BlobstoreService
 */
public class HeadResult {

  public static HeadResult create(String hash, long contentLength) {
    return new HeadResult(hash, contentLength);
  }

  private final String hash;
  private final long contentLength;

  HeadResult(String hash, long contentLength) {
    this.hash = hash;
    this.contentLength = contentLength;
  }

  public String hash() {
    return hash;
  }

  public long contentLength() {
    return contentLength;
  }
}
