package io.atlassian.blobstore.client.api;


import com.atlassian.fugue.Option;

public interface ContentKeyFactory {
  /**
   * Marshalls a key into a BlobKey object. This is a partial injective function that will produce an Option.None where undefined.
   * The produced BlobKey should be compatible with the {@link io.atlassian.blobstore.client.api.ContentKeyFactory#unmarshall(ContentKey)} method.
   * The following invariant should hold:
   * { ForAll (id: String such as marshall(id).isDefined): unmarshall(marshall(id)).equals(id) }
   *
   * @param id
   * @return
   */
  Option<ContentKey> marshall(String id);

  /**
   * Unmarshalls a key into a String, suitable for storage and transport.
   * The produced String should be compatible with the {@link io.atlassian.blobstore.client.api.ContentKeyFactory#marshall(String)} method.
   * The following invariant should hold:
   * { ForAll (key: BlobKey): marshall(unmarshall(key)).equals(key) }
   *
   * @param key
   * @return
   */
  String unmarshall(ContentKey key);
}
