/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.BigDecimalCodec;
import io.asyncer.r2dbc.mysql.codec.BigIntegerCodec;
import io.asyncer.r2dbc.mysql.codec.BitSetCodec;
import io.asyncer.r2dbc.mysql.codec.BlobCodec;
import io.asyncer.r2dbc.mysql.codec.BooleanCodec;
import io.asyncer.r2dbc.mysql.codec.ByteArrayCodec;
import io.asyncer.r2dbc.mysql.codec.ByteBufferCodec;
import io.asyncer.r2dbc.mysql.codec.ByteCodec;
import io.asyncer.r2dbc.mysql.codec.ClobCodec;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.codec.CodecsBuilder;
import io.asyncer.r2dbc.mysql.codec.DoubleCodec;
import io.asyncer.r2dbc.mysql.codec.DurationCodec;
import io.asyncer.r2dbc.mysql.codec.EnumCodec;
import io.asyncer.r2dbc.mysql.codec.FloatCodec;
import io.asyncer.r2dbc.mysql.codec.InstantCodec;
import io.asyncer.r2dbc.mysql.codec.IntegerCodec;
import io.asyncer.r2dbc.mysql.codec.LocalDateCodec;
import io.asyncer.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.asyncer.r2dbc.mysql.codec.LocalTimeCodec;
import io.asyncer.r2dbc.mysql.codec.LongCodec;
import io.asyncer.r2dbc.mysql.codec.MassiveCodec;
import io.asyncer.r2dbc.mysql.codec.MassiveParameterizedCodec;
import io.asyncer.r2dbc.mysql.codec.NullMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.OffsetDateTimeCodec;
import io.asyncer.r2dbc.mysql.codec.OffsetTimeCodec;
import io.asyncer.r2dbc.mysql.codec.ParameterizedCodec;
import io.asyncer.r2dbc.mysql.codec.SetCodec;
import io.asyncer.r2dbc.mysql.codec.ShortCodec;
import io.asyncer.r2dbc.mysql.codec.StringCodec;
import io.asyncer.r2dbc.mysql.codec.YearCodec;
import io.asyncer.r2dbc.mysql.codec.ZonedDateTimeCodec;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.asyncer.r2dbc.mysql.message.LargeFieldValue;
import io.asyncer.r2dbc.mysql.message.NormalFieldValue;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Parameter;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.Nullable;

final class DefaultCodecs
implements Codecs {
    private static final List<Codec<?>> DEFAULT_CODECS = InternalArrays.asImmutableList(ByteCodec.INSTANCE, ShortCodec.INSTANCE, IntegerCodec.INSTANCE, LongCodec.INSTANCE, BigIntegerCodec.INSTANCE, BigDecimalCodec.INSTANCE, FloatCodec.INSTANCE, DoubleCodec.INSTANCE, BooleanCodec.INSTANCE, BitSetCodec.INSTANCE, ZonedDateTimeCodec.INSTANCE, LocalDateTimeCodec.INSTANCE, InstantCodec.INSTANCE, OffsetDateTimeCodec.INSTANCE, LocalDateCodec.INSTANCE, LocalTimeCodec.INSTANCE, DurationCodec.INSTANCE, OffsetTimeCodec.INSTANCE, YearCodec.INSTANCE, StringCodec.INSTANCE, EnumCodec.INSTANCE, SetCodec.INSTANCE, ClobCodec.INSTANCE, BlobCodec.INSTANCE, ByteBufferCodec.INSTANCE, ByteArrayCodec.INSTANCE);
    private final List<Codec<?>> codecs;
    private final ParameterizedCodec<?>[] parameterizedCodecs;
    private final MassiveCodec<?>[] massiveCodecs;
    private final MassiveParameterizedCodec<?>[] massiveParameterizedCodecs;
    private final Map<Class<?>, Codec<?>> fastPath;

    private DefaultCodecs(List<Codec<?>> codecs) {
        AssertUtils.requireNonNull(codecs, "codecs must not be null");
        HashMap fastPath = new HashMap();
        ArrayList<ParameterizedCodec> parameterizedCodecs = new ArrayList<ParameterizedCodec>();
        ArrayList<MassiveCodec> massiveCodecs = new ArrayList<MassiveCodec>();
        ArrayList<MassiveParameterizedCodec> massiveParamCodecs = new ArrayList<MassiveParameterizedCodec>();
        for (Codec<?> codec : codecs) {
            Class<?> mainClass = codec.getMainClass();
            if (mainClass != null) {
                fastPath.putIfAbsent(mainClass, codec);
            }
            if (codec instanceof AbstractPrimitiveCodec) {
                AbstractPrimitiveCodec c = (AbstractPrimitiveCodec)codec;
                fastPath.putIfAbsent(c.getPrimitiveClass(), c);
            } else if (codec instanceof ParameterizedCodec) {
                parameterizedCodecs.add((ParameterizedCodec)codec);
            }
            if (!(codec instanceof MassiveCodec)) continue;
            massiveCodecs.add((MassiveCodec)codec);
            if (!(codec instanceof MassiveParameterizedCodec)) continue;
            massiveParamCodecs.add((MassiveParameterizedCodec)codec);
        }
        this.fastPath = fastPath;
        this.codecs = codecs;
        this.massiveCodecs = massiveCodecs.toArray(new MassiveCodec[0]);
        this.massiveParameterizedCodecs = massiveParamCodecs.toArray(new MassiveParameterizedCodec[0]);
        this.parameterizedCodecs = parameterizedCodecs.toArray(new ParameterizedCodec[0]);
    }

    @Override
    public <T> T decode(FieldValue value, MySqlReadableMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(metadata, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        if (value.isNull()) {
            return null;
        }
        Class<?> target = DefaultCodecs.chooseClass(metadata, type);
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, metadata, target, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, metadata, target, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decode(FieldValue value, MySqlReadableMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(metadata, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        if (value.isNull()) {
            return null;
        }
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, metadata, type, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decodeLastInsertId(long value, Class<?> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        if (Byte.TYPE == type || Byte.class == type) {
            return (T)Byte.valueOf((byte)value);
        }
        if (Short.TYPE == type || Short.class == type) {
            return (T)Short.valueOf((short)value);
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return (T)Integer.valueOf((int)value);
        }
        if (Long.TYPE == type || Long.class == type) {
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == type) {
            if (value < 0L) {
                return (T)CodecUtils.unsignedBigInteger(value);
            }
            return (T)BigInteger.valueOf(value);
        }
        if (type.isAssignableFrom(Number.class)) {
            if (value < 0L) {
                return (T)CodecUtils.unsignedBigInteger(value);
            }
            return (T)Long.valueOf(value);
        }
        throw new IllegalArgumentException(String.format("Cannot decode %s with last inserted ID %s", type, value < 0L ? Long.toUnsignedString(value) : Long.valueOf(value)));
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        Object valueToEncode = DefaultCodecs.getValueToEncode(value);
        if (null == valueToEncode) {
            return this.encodeNull();
        }
        Codec fast = this.encodeFast(valueToEncode);
        if (fast != null && fast.canEncode(valueToEncode)) {
            return fast.encode(valueToEncode, context);
        }
        for (Codec<?> codec : this.codecs) {
            if (codec == fast || !codec.canEncode(valueToEncode)) continue;
            return codec.encode(valueToEncode, context);
        }
        throw new IllegalArgumentException("Cannot encode " + valueToEncode.getClass());
    }

    @Nullable
    private static Object getValueToEncode(Object value) {
        if (value instanceof Parameter) {
            return ((Parameter)value).getValue();
        }
        return value;
    }

    @Override
    public MySqlParameter encodeNull() {
        return NullMySqlParameter.INSTANCE;
    }

    @Nullable
    private <T> Codec<T> decodeFast(Class<?> type) {
        Codec<?> codec = this.fastPath.get(type);
        if (codec == null && type.isEnum()) {
            return this.fastPath.get(Enum.class);
        }
        return codec;
    }

    @Nullable
    private <T> Codec<T> encodeFast(Object value) {
        Codec<?> codec = this.fastPath.get(value.getClass());
        if (codec == null) {
            if (value instanceof ByteBuffer) {
                return this.fastPath.get(ByteBuffer.class);
            }
            if (value instanceof Blob) {
                return this.fastPath.get(Blob.class);
            }
            if (value instanceof Clob) {
                return this.fastPath.get(Clob.class);
            }
            if (value instanceof Enum) {
                return this.fastPath.get(Enum.class);
            }
        }
        return codec;
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, MySqlReadableMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        Codec<T> fast = this.decodeFast(type);
        if (fast != null && fast.canDecode(metadata, type)) {
            return fast.decode(value.getBufferSlice(), metadata, type, binary, context);
        }
        for (Codec<?> codec : this.codecs) {
            if (codec == fast || !codec.canDecode(metadata, type)) continue;
            Codec<?> c = codec;
            return (T)c.decode(value.getBufferSlice(), metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, MySqlReadableMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        for (ParameterizedCodec<?> codec : this.parameterizedCodecs) {
            if (!codec.canDecode(metadata, type)) continue;
            Object result = codec.decode(value.getBufferSlice(), metadata, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, MySqlReadableMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        Codec<T> fast = this.decodeFast(type);
        if (fast instanceof MassiveCodec && fast.canDecode(metadata, type)) {
            return ((MassiveCodec)fast).decodeMassive(value.getBufferSlices(), metadata, type, binary, context);
        }
        for (MassiveCodec<?> codec : this.massiveCodecs) {
            if (codec == fast || !codec.canDecode(metadata, type)) continue;
            MassiveCodec<?> c = codec;
            return (T)c.decodeMassive(value.getBufferSlices(), metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode massive " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, MySqlReadableMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        for (MassiveParameterizedCodec<?> codec : this.massiveParameterizedCodecs) {
            if (!codec.canDecode(metadata, type)) continue;
            Object result = codec.decodeMassive(value.getBufferSlices(), metadata, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode massive  " + type + " for " + (Object)((Object)metadata.getType()));
    }

    private static Class<?> chooseClass(MySqlReadableMetadata metadata, Class<?> type) {
        Class<?> javaType = metadata.getType().getJavaType();
        return type.isAssignableFrom(javaType) ? javaType : type;
    }

    static final class Builder
    implements CodecsBuilder {
        @GuardedBy(value="lock")
        private final ArrayList<Codec<?>> codecs = new ArrayList();
        private final ReentrantLock lock = new ReentrantLock();

        Builder() {
        }

        @Override
        public CodecsBuilder addFirst(Codec<?> codec) {
            this.lock.lock();
            try {
                if (this.codecs.isEmpty()) {
                    this.codecs.ensureCapacity(DEFAULT_CODECS.size() + 1);
                    this.codecs.add(codec);
                    this.codecs.addAll(DEFAULT_CODECS);
                } else {
                    this.codecs.add(0, codec);
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public CodecsBuilder addLast(Codec<?> codec) {
            this.lock.lock();
            try {
                if (this.codecs.isEmpty()) {
                    this.codecs.addAll(DEFAULT_CODECS);
                }
                this.codecs.add(codec);
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public Codecs build() {
            this.lock.lock();
            try {
                block8: {
                    try {
                        if (!this.codecs.isEmpty()) break block8;
                        DefaultCodecs defaultCodecs = new DefaultCodecs(DEFAULT_CODECS);
                        this.codecs.clear();
                        this.codecs.trimToSize();
                        return defaultCodecs;
                    }
                    catch (Throwable throwable) {
                        this.codecs.clear();
                        this.codecs.trimToSize();
                        throw throwable;
                    }
                }
                DefaultCodecs defaultCodecs = new DefaultCodecs(InternalArrays.asImmutableList(this.codecs.toArray(new Codec[0])));
                this.codecs.clear();
                this.codecs.trimToSize();
                return defaultCodecs;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

