/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.BitSet;
import reactor.core.publisher.Mono;

final class BitSetCodec
extends AbstractClassedCodec<BitSet> {
    BitSetCodec(ByteBufAllocator allocator) {
        super(allocator, BitSet.class);
    }

    @Override
    public BitSet decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return BitSet.valueOf(InternalArrays.EMPTY_BYTES);
        }
        return BitSet.valueOf(BitSetCodec.reverse(ByteBufUtil.getBytes((ByteBuf)value)));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BitSet;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        long[] array;
        BitSet set = (BitSet)value;
        long bits = set.isEmpty() ? 0L : ((array = set.toLongArray()).length == 0 ? 0L : array[0]);
        MySqlType type = (long)((byte)bits) == bits ? MySqlType.TINYINT : ((long)((short)bits) == bits ? MySqlType.SMALLINT : ((long)((int)bits) == bits ? MySqlType.INT : MySqlType.BIGINT));
        return new BitSetMySqlParameter(this.allocator, bits, type);
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType() == MySqlType.BIT;
    }

    private static byte[] reverse(byte[] bytes) {
        int maxIndex = bytes.length - 1;
        int half = bytes.length >>> 1;
        for (int i = 0; i < half; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[maxIndex - i];
            bytes[maxIndex - i] = b;
        }
        return bytes;
    }

    private static final class BitSetMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final long value;
        private final MySqlType type;

        private BitSetMySqlParameter(ByteBufAllocator allocator, long value, MySqlType type) {
            this.allocator = allocator;
            this.value = value;
            this.type = type;
        }

        public Mono<ByteBuf> publishBinary() {
            switch (this.type) {
                case TINYINT: {
                    return Mono.fromSupplier(() -> this.allocator.buffer(1).writeByte((int)this.value));
                }
                case SMALLINT: {
                    return Mono.fromSupplier(() -> this.allocator.buffer(2).writeShortLE((int)this.value));
                }
                case INT: {
                    return Mono.fromSupplier(() -> this.allocator.buffer(4).writeIntLE((int)this.value));
                }
            }
            return Mono.fromSupplier(() -> this.allocator.buffer(8).writeLongLE(this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> {
                if (this.value == 0L) {
                    writer.writeBinary(false);
                } else {
                    writer.writeHex(this.value);
                }
            });
        }

        @Override
        public MySqlType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BitSetMySqlParameter)) {
                return false;
            }
            BitSetMySqlParameter that = (BitSetMySqlParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }
}

