/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.authentication;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class AuthUtils {
    static byte[] hash(String algorithm, boolean left, CharSequence plain, byte[] salt, Charset charset) {
        MessageDigest digest = AuthUtils.loadDigest(algorithm);
        byte[] oneRound = AuthUtils.digestBuffer(digest, charset.encode(CharBuffer.wrap(plain)));
        byte[] twoRounds = AuthUtils.finalDigests(digest, oneRound);
        return AuthUtils.allBytesXor(AuthUtils.finalDigests(digest, left, salt, twoRounds), oneRound);
    }

    static byte[] encodeTerminal(CharBuffer chars, Charset charset) {
        ByteBuffer buffer = charset.encode(chars);
        int maxIndex = buffer.remaining();
        byte[] bytes = new byte[maxIndex + 1];
        buffer.get(bytes, 0, maxIndex);
        bytes[maxIndex] = 0;
        return bytes;
    }

    private static MessageDigest loadDigest(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
    }

    private static byte[] finalDigests(MessageDigest digest, byte[] plain) {
        digest.reset();
        digest.update(plain);
        return digest.digest();
    }

    private static byte[] finalDigests(MessageDigest digest, boolean leftFirst, byte[] left, byte[] right) {
        digest.reset();
        if (leftFirst) {
            digest.update(left);
            digest.update(right);
        } else {
            digest.update(right);
            digest.update(left);
        }
        return digest.digest();
    }

    private static byte[] digestBuffer(MessageDigest digest, ByteBuffer buffer) {
        digest.update(buffer);
        return digest.digest();
    }

    private static byte[] allBytesXor(byte[] left, byte[] right) {
        int size = left.length;
        if (size != right.length) {
            throw new IllegalArgumentException("Cannot xor different sizes " + size + " and " + right.length);
        }
        for (int i = 0; i < size; ++i) {
            int n = i;
            left[n] = (byte)(left[n] ^ right[i]);
        }
        return left;
    }

    private AuthUtils() {
    }
}

