/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.message.client.SizedClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;

final class SslRequest41
extends SizedClientMessage
implements SslRequest {
    private static final int FILTER_SIZE = 23;
    private static final int BUF_SIZE = 32;
    private final int envelopeId;
    private final Capability capability;
    private final int collationId;

    SslRequest41(int envelopeId, Capability capability, int collationId) {
        AssertUtils.require(collationId > 0, "collationId must be a positive integer");
        this.envelopeId = envelopeId;
        this.capability = capability;
        this.collationId = collationId;
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslRequest41 that = (SslRequest41)o;
        return this.envelopeId == that.envelopeId && this.collationId == that.collationId && this.capability.equals(that.capability);
    }

    public int hashCode() {
        int result = 31 * this.envelopeId + this.capability.hashCode();
        return 31 * result + this.collationId;
    }

    public String toString() {
        return "SslRequest41{envelopeId=" + this.envelopeId + ", capability=" + this.capability + ", collationId=" + this.collationId + '}';
    }

    @Override
    public Capability getCapability() {
        return this.capability;
    }

    @Override
    protected int size() {
        return 32;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeIntLE(this.capability.getBitmap()).writeIntLE(0xFFFFFF).writeByte(this.collationId & 0xFF).writeZero(23);
    }

    int getCollationId() {
        return this.collationId;
    }
}

