/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.message.client.SizedClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;

final class SslRequest320
extends SizedClientMessage
implements SslRequest {
    private static final int SIZE = 5;
    private final int envelopeId;
    private final Capability capability;

    SslRequest320(int envelopeId, Capability capability) {
        AssertUtils.require(!capability.isProtocol41(), "protocol 4.1 capability should never be set");
        this.envelopeId = envelopeId;
        this.capability = capability;
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    @Override
    public Capability getCapability() {
        return this.capability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslRequest320 that = (SslRequest320)o;
        return this.envelopeId == that.envelopeId && this.capability.equals(that.capability);
    }

    public int hashCode() {
        return 31 * this.envelopeId + this.capability.hashCode();
    }

    public String toString() {
        return "SslRequest320{envelopeId=" + this.envelopeId + ", capability=" + this.capability + '}';
    }

    @Override
    protected int size() {
        return 5;
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeShortLE(this.capability.getBitmap() & 0xFFFF).writeMediumLE(0xFFFFFF);
    }
}

