/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.message.client.HandshakeResponse;
import io.asyncer.r2dbc.mysql.message.client.ScalarClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest320;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Arrays;

final class HandshakeResponse320
extends ScalarClientMessage
implements HandshakeResponse {
    private final SslRequest320 header;
    private final String user;
    private final byte[] authentication;
    private final String database;

    HandshakeResponse320(int envelopeId, Capability capability, String user, byte[] authentication, String database) {
        this.header = new SslRequest320(envelopeId, capability);
        this.user = AssertUtils.requireNonNull(user, "user must not be null");
        this.authentication = AssertUtils.requireNonNull(authentication, "authentication must not be null");
        this.database = AssertUtils.requireNonNull(database, "database must not be null");
    }

    @Override
    public int getEnvelopeId() {
        return this.header.getEnvelopeId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandshakeResponse320 that = (HandshakeResponse320)o;
        return this.header.equals(that.header) && this.user.equals(that.user) && Arrays.equals(this.authentication, that.authentication) && this.database.equals(that.database);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + this.user.hashCode();
        result = 31 * result + Arrays.hashCode(this.authentication);
        return 31 * result + this.database.hashCode();
    }

    public String toString() {
        return "HandshakeResponse320{envelopeId=" + this.header.getEnvelopeId() + ", capability=" + this.header.getCapability() + ", user='" + this.user + "', authentication=REDACTED, database='" + this.database + "'}";
    }

    @Override
    protected void writeTo(ByteBuf buf, ConnectionContext context) {
        this.header.writeTo(buf);
        Charset charset = context.getClientCollation().getCharset();
        HandshakeResponse.writeCString(buf, this.user, charset);
        if (this.header.getCapability().isConnectWithDatabase()) {
            if (this.authentication.length == 0) {
                buf.writeByte(0);
            } else {
                buf.writeBytes(this.authentication);
                if (this.authentication[this.authentication.length - 1] != 0) {
                    buf.writeByte(0);
                }
            }
            HandshakeResponse.writeCString(buf, this.database, charset);
        } else {
            buf.writeBytes(this.authentication);
        }
    }
}

