/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec.lob;

import io.asyncer.r2dbc.mysql.codec.lob.MultiBlob;
import io.asyncer.r2dbc.mysql.codec.lob.MultiClob;
import io.asyncer.r2dbc.mysql.codec.lob.SingletonBlob;
import io.asyncer.r2dbc.mysql.codec.lob.SingletonClob;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.util.NettyBufferUtils;
import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import java.util.List;

public final class LobUtils {
    public static Blob createBlob(ByteBuf value) {
        ByteBuf buf = value.retain();
        try {
            return new SingletonBlob(buf);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    public static Blob createBlob(List<ByteBuf> value) {
        int i;
        int size = value.size();
        try {
            for (i = 0; i < size; ++i) {
                value.get(i).retain();
            }
            return new MultiBlob(value);
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(value, i);
            throw e;
        }
    }

    public static Clob createClob(ByteBuf value, CharCollation collation) {
        ByteBuf buf = value.retain();
        try {
            return new SingletonClob(buf, collation);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    public static Clob createClob(List<ByteBuf> value, CharCollation collation) {
        int i;
        int size = value.size();
        try {
            for (i = 0; i < size; ++i) {
                value.get(i).retain();
            }
            return new MultiClob(value, collation);
        }
        catch (Throwable e) {
            NettyBufferUtils.releaseAll(value, i);
            throw e;
        }
    }

    private LobUtils() {
    }
}

