/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import reactor.util.annotation.Nullable;

final class DateTimes {
    static final int DATE_SIZE = 4;
    static final int DATETIME_SIZE = 7;
    static final int MICRO_DATETIME_SIZE = 11;
    static final int TIME_SIZE = 8;
    static final int MICRO_TIME_SIZE = 12;
    static final int HOURS_OF_DAY = 24;
    static final int SECONDS_OF_MINUTE = 60;
    static final int SECONDS_OF_HOUR = 3600;
    static final int SECONDS_OF_DAY = 86400;
    static final int NANOS_OF_SECOND = 1000000000;
    static final int NANOS_OF_MICRO = 1000;
    private static final String ILLEGAL_ARGUMENT = "S1009";
    private static final int MICRO_DIGITS = 6;

    static int readMicroInDigits(ByteBuf buf) {
        byte digit;
        int num;
        if (!buf.isReadable()) {
            return 0;
        }
        int micro = 0;
        for (num = 6; buf.isReadable() && num > 0 && (digit = buf.readByte()) >= 48 && digit <= 57; --num) {
            micro = micro * 10 + (digit - 48);
        }
        while (num-- > 0) {
            micro *= 10;
        }
        return micro;
    }

    static int readIntInDigits(ByteBuf buf) {
        if (!buf.isReadable()) {
            return 0;
        }
        int writerIndex = buf.writerIndex();
        int result = 0;
        for (int i = buf.readerIndex(); i < writerIndex; ++i) {
            byte digit = buf.getByte(i);
            if (digit < 48 || digit > 57) {
                buf.readerIndex(i + 1);
                return result;
            }
            result = result * 10 + (digit - 48);
        }
        buf.readerIndex(writerIndex);
        return result;
    }

    @Nullable
    static <T extends Temporal> T zeroDate(ZeroDateOption option, boolean binary, T round) {
        switch (option) {
            case USE_NULL: {
                return null;
            }
            case USE_ROUND: {
                return round;
            }
        }
        throw new R2dbcNonTransientResourceException((binary ? "Binary" : "Text") + " value is zero date and ZeroDateOption is " + (Object)((Object)ZeroDateOption.EXCEPTION), ILLEGAL_ARGUMENT);
    }

    static boolean canDecodeChronology(MySqlType type, ParameterizedType target, Class<? extends Temporal> chronology) {
        return (type == MySqlType.DATETIME || type == MySqlType.TIMESTAMP) && LocalDate.class == CodecUtils.getTypeArgument(target, chronology);
    }

    static boolean canDecodeDateTime(MySqlType type, Class<?> target, Class<? extends Temporal> temporal) {
        return (type == MySqlType.DATETIME || type == MySqlType.TIMESTAMP) && target.isAssignableFrom(temporal);
    }

    private DateTimes() {
    }
}

