/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.util.InternalArrays;
import io.asyncer.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;
import reactor.core.publisher.Mono;

final class ByteArrayCodec
extends AbstractClassedCodec<byte[]> {
    ByteArrayCodec(ByteBufAllocator allocator) {
        super(allocator, byte[].class);
    }

    @Override
    public byte[] decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return InternalArrays.EMPTY_BYTES;
        }
        return ByteBufUtil.getBytes((ByteBuf)value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof byte[];
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new ByteArrayMySqlParameter(this.allocator, (byte[])value);
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isBinary();
    }

    static ByteBuf encodeBytes(ByteBufAllocator alloc, byte[] value) {
        int size = value.length;
        if (size == 0) {
            return alloc.buffer(1).writeByte(0);
        }
        ByteBuf buf = alloc.buffer(VarIntUtils.varIntBytes(size) + size);
        try {
            VarIntUtils.writeVarInt(buf, size);
            return buf.writeBytes(value);
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    private static final class ByteArrayMySqlParameter
    extends AbstractMySqlParameter {
        private final ByteBufAllocator allocator;
        private final byte[] value;

        private ByteArrayMySqlParameter(ByteBufAllocator allocator, byte[] value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> ByteArrayCodec.encodeBytes(this.allocator, this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeHex(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARBINARY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayMySqlParameter)) {
                return false;
            }
            ByteArrayMySqlParameter that = (ByteArrayMySqlParameter)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }
}

