/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoSink;
import reactor.util.annotation.Nullable;

final class RequestTask<T> {
    @Nullable
    private final Disposable disposable;
    private final MonoSink<T> sink;
    private final T supplier;

    private RequestTask(@Nullable Disposable disposable, MonoSink<T> sink, T supplier) {
        this.disposable = disposable;
        this.sink = sink;
        this.supplier = supplier;
    }

    void run() {
        this.sink.success(this.supplier);
    }

    void cancel(Throwable e) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.sink.error(e);
    }

    static <T> RequestTask<T> wrap(ClientMessage message, MonoSink<T> sink, T supplier) {
        if (message instanceof Disposable) {
            return new RequestTask<T>((Disposable)message, sink, supplier);
        }
        return new RequestTask<T>(null, sink, supplier);
    }

    static <T> RequestTask<T> wrap(Flux<? extends ClientMessage> messages, MonoSink<T> sink, T supplier) {
        return new RequestTask<T>(new DisposableFlux(messages), sink, supplier);
    }

    static <T> RequestTask<T> wrap(MonoSink<T> sink, T supplier) {
        return new RequestTask<T>(null, sink, supplier);
    }

    private static final class DisposableFlux
    implements Disposable {
        private final Flux<? extends ClientMessage> messages;

        private DisposableFlux(Flux<? extends ClientMessage> messages) {
            this.messages = messages;
        }

        public void dispose() {
            Flux.from(this.messages).subscribe(it -> {
                if (it instanceof Disposable) {
                    ((Disposable)it).dispose();
                }
            });
        }
    }
}

