/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.client.RequestQueue;
import io.asyncer.r2dbc.mysql.client.SslState;
import io.asyncer.r2dbc.mysql.client.WriteSubscriber;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.client.LoginClientMessage;
import io.asyncer.r2dbc.mysql.message.client.PrepareQueryMessage;
import io.asyncer.r2dbc.mysql.message.client.PreparedFetchMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest;
import io.asyncer.r2dbc.mysql.message.server.ColumnCountMessage;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.DecodeContext;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.PreparedOkMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessageDecoder;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.asyncer.r2dbc.mysql.util.OperatorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.util.Logger;
import reactor.util.Loggers;

final class MessageDuplexCodec
extends ChannelDuplexHandler {
    static final String NAME = "R2dbcMySqlMessageDuplexCodec";
    private static final Logger logger = Loggers.getLogger(MessageDuplexCodec.class);
    private DecodeContext decodeContext = DecodeContext.login();
    private final ConnectionContext context;
    private final AtomicBoolean closing;
    private final RequestQueue requestQueue;
    private final ServerMessageDecoder decoder = new ServerMessageDecoder();

    MessageDuplexCodec(ConnectionContext context, AtomicBoolean closing, RequestQueue requestQueue) {
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
        this.closing = AssertUtils.requireNonNull(closing, "closing must not be null");
        this.requestQueue = AssertUtils.requireNonNull(requestQueue, "requestQueue must not be null");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            DecodeContext context = this.decodeContext;
            ServerMessage message = this.decoder.decode((ByteBuf)msg, this.context, context);
            if (message != null) {
                this.handleDecoded(ctx, message);
            }
        } else if (msg instanceof ServerMessage) {
            ctx.fireChannelRead(msg);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Unknown message type {} on reading", new Object[]{msg.getClass()});
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ClientMessage) {
            int envelopeId;
            Flux encoded;
            ByteBufAllocator allocator = ctx.alloc();
            if (msg instanceof LoginClientMessage) {
                LoginClientMessage message = (LoginClientMessage)msg;
                encoded = Flux.from(message.encode(allocator, this.context));
                envelopeId = message.getEnvelopeId();
            } else {
                encoded = Flux.from(((ClientMessage)msg).encode(allocator, this.context));
                envelopeId = 0;
            }
            OperatorUtils.cumulateEnvelope((Flux<? extends ByteBuf>)encoded, allocator, envelopeId).subscribe((CoreSubscriber)new WriteSubscriber(ctx, promise));
            if (msg instanceof PrepareQueryMessage) {
                this.setDecodeContext(DecodeContext.prepareQuery());
            } else if (msg instanceof PreparedFetchMessage) {
                this.setDecodeContext(DecodeContext.fetch());
            } else if (msg instanceof SslRequest) {
                ctx.channel().pipeline().fireUserEventTriggered((Object)SslState.BRIDGING);
            }
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Unknown message type {} on writing", new Object[]{msg.getClass()});
            }
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.decoder.dispose();
        this.requestQueue.dispose();
        if (this.closing.compareAndSet(false, true)) {
            logger.warn("Connection has been closed by peer");
        }
        ctx.fireChannelInactive();
    }

    private void handleDecoded(ChannelHandlerContext ctx, ServerMessage msg) {
        if (msg instanceof ServerStatusMessage) {
            this.context.setServerStatuses(((ServerStatusMessage)msg).getServerStatuses());
        }
        if (msg instanceof CompleteMessage) {
            this.setDecodeContext(DecodeContext.command());
        } else if (msg instanceof SyntheticMetadataMessage) {
            if (((SyntheticMetadataMessage)msg).isCompleted()) {
                this.setDecodeContext(DecodeContext.command());
            }
        } else {
            if (msg instanceof ColumnCountMessage) {
                this.setDecodeContext(DecodeContext.result(this.context.getCapability().isEofDeprecated(), ((ColumnCountMessage)msg).getTotalColumns()));
                return;
            }
            if (msg instanceof PreparedOkMessage) {
                int parameters;
                PreparedOkMessage message = (PreparedOkMessage)msg;
                int columns = message.getTotalColumns();
                if (columns > -(parameters = message.getTotalParameters())) {
                    this.setDecodeContext(DecodeContext.preparedMetadata(this.context.getCapability().isEofDeprecated(), columns, parameters));
                } else {
                    this.setDecodeContext(DecodeContext.command());
                }
            } else if (msg instanceof ErrorMessage) {
                this.setDecodeContext(DecodeContext.command());
            }
        }
        ctx.fireChannelRead((Object)msg);
    }

    private void setDecodeContext(DecodeContext context) {
        this.decodeContext = context;
        if (logger.isDebugEnabled()) {
            logger.debug("Decode context change to {}", new Object[]{context});
        }
    }
}

