/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ParameterIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class Query {
    private final String sql;
    private final Map<String, ParameterIndex> namedIndexes;
    private final List<Part> parts;
    private final int formattedSize;
    @Nullable
    private String formattedSql;

    private Query(String sql, Map<String, ParameterIndex> namedIndexes, List<Part> parts, int formattedSize) {
        this.sql = sql;
        this.namedIndexes = namedIndexes;
        this.parts = parts;
        this.formattedSize = formattedSize;
    }

    public void partTo(StringBuilder builder, int i) {
        Part part = this.parts.get(i);
        builder.append(this.sql, part.start, part.end);
    }

    public int getFormattedSize() {
        return this.formattedSize;
    }

    public int getPartSize() {
        return this.parts.size();
    }

    boolean isSimple() {
        return this.parts.isEmpty();
    }

    int getParameters() {
        int size = this.parts.size();
        return size > 1 ? size - 1 : 0;
    }

    String getFormattedSql() {
        String formattedSql = this.formattedSql;
        if (formattedSql == null) {
            if (this.namedIndexes.isEmpty()) {
                this.formattedSql = formattedSql = this.sql;
            } else {
                Part part = this.parts.get(0);
                char[] result = new char[this.formattedSize];
                int size = this.parts.size();
                int length = 0;
                if (part.end > part.start) {
                    this.sql.getChars(part.start, part.end, result, 0);
                    length = part.end - part.start;
                }
                for (int i = 1; i < size; ++i) {
                    result[length++] = 63;
                    part = this.parts.get(i);
                    if (part.end <= part.start) continue;
                    this.sql.getChars(part.start, part.end, result, length);
                    length += part.end - part.start;
                }
                this.formattedSql = formattedSql = new String(result);
            }
        }
        return formattedSql;
    }

    Map<String, ParameterIndex> getNamedIndexes() {
        return this.namedIndexes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return this.formattedSize == query.formattedSize && this.sql.equals(query.sql) && this.namedIndexes.equals(query.namedIndexes) && this.parts.equals(query.parts);
    }

    public int hashCode() {
        int result = this.sql.hashCode();
        result = 31 * result + this.namedIndexes.hashCode();
        result = 31 * result + this.parts.hashCode();
        return 31 * result + this.formattedSize;
    }

    public String toString() {
        return "Query{sql='" + this.sql + "', namedIndexes=" + this.namedIndexes + ", parts=" + this.parts + ", formattedSize=" + this.formattedSize + '}';
    }

    public static Query parse(String sql) {
        int offset = Query.findParamMark(sql, 0);
        if (offset < 0) {
            return new Query(sql, Collections.emptyMap(), Collections.emptyList(), sql.length());
        }
        HashMap<String, ParameterIndex> nameKeyedParams = new HashMap<String, ParameterIndex>();
        String anyName = "";
        int lastParamEnd = 0;
        int length = sql.length();
        int paramCount = 0;
        int formattedSize = 0;
        ArrayList<Part> parts = new ArrayList<Part>();
        while (offset >= 0 && offset < length) {
            parts.add(Part.of(lastParamEnd, offset));
            formattedSize += offset - lastParamEnd + 1;
            ++paramCount;
            lastParamEnd = ++offset;
            if (offset >= length) continue;
            if (Character.isJavaIdentifierStart(sql.charAt(offset))) {
                int start = offset++;
                while (offset < length && Character.isJavaIdentifierPart(sql.charAt(offset))) {
                    ++offset;
                }
                lastParamEnd = offset;
                String name = sql.substring(start, offset);
                int paramIndex = paramCount - 1;
                ParameterIndex value = (ParameterIndex)nameKeyedParams.get(name);
                anyName = name;
                if (value == null) {
                    nameKeyedParams.put(name, new ParameterIndex(paramIndex));
                } else {
                    value.push(paramIndex);
                }
                if (offset >= length) continue;
                offset = Query.findParamMark(sql, offset);
                continue;
            }
            offset = Query.findParamMark(sql, offset);
        }
        parts.add(Part.of(lastParamEnd, length));
        return new Query(sql, Query.wrap(nameKeyedParams, anyName), parts, formattedSize += length - lastParamEnd);
    }

    private static int findParamMark(CharSequence sql, int start) {
        int offset = start;
        int length = sql.length();
        block5: while (offset < length && offset >= 0) {
            char ch = sql.charAt(offset++);
            switch (ch) {
                case '/': {
                    if (offset == length || sql.charAt(offset) != '*') continue block5;
                    while (++offset < length) {
                        if (sql.charAt(offset) != '*' || offset + 1 >= length || sql.charAt(offset + 1) != '/') continue;
                        offset += 2;
                        continue block5;
                    }
                    continue block5;
                }
                case '-': {
                    if (offset == length || sql.charAt(offset) != '-') continue block5;
                    while (++offset < length) {
                        char now = sql.charAt(offset);
                        if (now != '\n' && now != '\r') continue;
                        ++offset;
                        continue block5;
                    }
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    while (offset < length) {
                        if (sql.charAt(offset++) != ch) continue;
                        if (length == offset || sql.charAt(offset) != ch) continue block5;
                        ++offset;
                    }
                    continue block5;
                }
            }
            if (ch != '?') continue;
            return offset - 1;
        }
        return -1;
    }

    private static Map<String, ParameterIndex> wrap(Map<String, ParameterIndex> map, String anyKey) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(anyKey, map.get(anyKey));
            }
        }
        return map;
    }

    private static final class Part {
        private static final Part EMPTY = new Part(0, 0);
        private final int start;
        private final int end;

        private Part(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Part part = (Part)o;
            return this.start == part.start && this.end == part.end;
        }

        public int hashCode() {
            return Integer.reverse(this.start) ^ this.end;
        }

        public String toString() {
            return this.start == this.end ? "()" : "(" + this.start + ", " + this.end + ')';
        }

        static Part of(int start, int end) {
            return start == end ? EMPTY : new Part(start, end);
        }
    }
}

