/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.collation.CharCollation;

public final class ColumnDefinition {
    private static final short NOT_NULL = 1;
    private static final short UNSIGNED = 32;
    public static final short BINARY = 128;
    private static final short ENUM = 256;
    private static final short SET = 2048;
    private static final short ALL_USED = 2465;
    private final short bitmap;
    private final int collationId;

    private ColumnDefinition(short bitmap, int collationId) {
        this.bitmap = bitmap;
        this.collationId = collationId;
    }

    public boolean isNotNull() {
        return (this.bitmap & 1) != 0;
    }

    public boolean isUnsigned() {
        return (this.bitmap & 0x20) != 0;
    }

    public boolean isBinary() {
        return this.collationId == 0 & (this.bitmap & 0x80) != 0 | this.collationId == CharCollation.BINARY_ID;
    }

    public boolean isEnum() {
        return (this.bitmap & 0x100) != 0;
    }

    public boolean isSet() {
        return (this.bitmap & 0x800) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return this.bitmap == that.bitmap & this.collationId == that.collationId;
    }

    public int hashCode() {
        return this.bitmap;
    }

    public String toString() {
        return "ColumnDefinition<0x" + Integer.toHexString(this.bitmap) + ", 0x" + Integer.toHexString(this.collationId) + '>';
    }

    public static ColumnDefinition of(int definitions) {
        return new ColumnDefinition((short)(definitions & 0x9A1), 0);
    }

    public static ColumnDefinition of(int definitions, int collationId) {
        return new ColumnDefinition((short)(definitions & 0x9A1), collationId);
    }
}

