/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module.internal;

import arrow.core.None;
import arrow.core.Option;
import arrow.core.Some;
import arrow.integrations.jackson.module.internal.ElementDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001aB?\bF\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000f\u0010\u0003\u001a\u00020\u0004X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Larrow/integrations/jackson/module/internal/ProductTypeDeserializer;", "T", "Ltools/jackson/databind/deser/std/StdDeserializer;", "javaType", "Ltools/jackson/databind/JavaType;", "fields", "", "Larrow/integrations/jackson/module/internal/ProductTypeDeserializer$InjectField;", "fold", "Lkotlin/Function1;", "<init>", "(Ltools/jackson/databind/JavaType;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "deserializers", "", "", "Larrow/integrations/jackson/module/internal/ElementDeserializer;", "deserialize", "parser", "Ltools/jackson/core/JsonParser;", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "(Ltools/jackson/core/JsonParser;Ltools/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "createContextual", "Ltools/jackson/databind/ValueDeserializer;", "property", "Ltools/jackson/databind/BeanProperty;", "InjectField", "arrow-core-jackson"})
@SourceDebugExtension(value={"SMAP\nProductTypeDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductTypeDeserializer.kt\narrow/integrations/jackson/module/internal/ProductTypeDeserializer\n+ 2 Iterable.kt\narrow/core/IterableKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n664#2,6:72\n1586#3:78\n1661#3,3:79\n*S KotlinDebug\n*F\n+ 1 ProductTypeDeserializer.kt\narrow/integrations/jackson/module/internal/ProductTypeDeserializer\n*L\n26#1:72,6\n43#1:78\n43#1:79,3\n*E\n"})
public final class ProductTypeDeserializer<T>
extends StdDeserializer<T> {
    @NotNull
    private final JavaType javaType;
    @NotNull
    private final List<InjectField<T>> fields;
    @NotNull
    private final Function1<List<? extends T>, T> fold;
    @NotNull
    private final Map<String, ElementDeserializer> deserializers;

    public ProductTypeDeserializer(@NotNull JavaType javaType, @NotNull List<InjectField<T>> fields, @NotNull Function1<? super List<? extends T>, ? extends T> fold) {
        Intrinsics.checkNotNullParameter((Object)javaType, (String)"javaType");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter(fold, (String)"fold");
        super(javaType);
        this.javaType = javaType;
        this.fields = fields;
        this.fold = fold;
        this.deserializers = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public T deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        List params = new ArrayList();
        Set introspectedFields = new LinkedHashSet();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String message;
            Object object;
            Option field;
            block7: {
                Option option;
                Iterable $this$firstOrNone$iv = this.fields;
                boolean $i$f$firstOrNone = false;
                for (Object element$iv : $this$firstOrNone$iv) {
                    InjectField it = (InjectField)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)parser.currentName(), (Object)it.getFieldName())) continue;
                    option = (Option)new Some(element$iv);
                    break block7;
                }
                option = field = (Option)None.INSTANCE;
            }
            if (field instanceof Some) {
                InjectField injectField = (InjectField)((Some)field).getValue();
                if (introspectedFields.add(injectField.getFieldName())) {
                    ElementDeserializer elementDeserializer;
                    if (this.deserializers.get(injectField.getFieldName()) == null) {
                        boolean $i$a$-requireNotNull-ProductTypeDeserializer$deserialize$elementDeserializer$22 = false;
                        String $i$a$-requireNotNull-ProductTypeDeserializer$deserialize$elementDeserializer$22 = "unexpected deserializer not found";
                        throw new IllegalArgumentException($i$a$-requireNotNull-ProductTypeDeserializer$deserialize$elementDeserializer$22.toString());
                    }
                    JsonToken jsonToken = parser.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonToken, (String)"nextToken(...)");
                    Object value = elementDeserializer.deserialize(this.javaType, jsonToken, parser, ctxt);
                    object = params.add(injectField.getPoint().invoke(value));
                    continue;
                }
                message = "Malformed Json: Field collision were detected for " + parser.currentName();
                object = ctxt.handleUnexpectedToken(this.javaType, parser.currentToken(), parser, message, new Object[0]);
                continue;
            }
            if (field instanceof None) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.fields;
                boolean $i$f$map = false;
                Iterable $i$a$-requireNotNull-ProductTypeDeserializer$deserialize$elementDeserializer$22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    InjectField injectField = (InjectField)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getFieldName());
                }
                List validFields = (List)destination$iv$iv;
                message = "Cannot deserialize " + this.javaType + ". Make sure json fields are valid: " + validFields + ".";
                object = ctxt.handleUnexpectedToken(this.javaType, parser.currentToken(), parser, message, new Object[0]);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return (T)this.fold.invoke((Object)params);
    }

    @NotNull
    public ValueDeserializer<?> createContextual(@NotNull DeserializationContext ctxt, @Nullable BeanProperty property) {
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        ProductTypeDeserializer<? extends T> deserializer = new ProductTypeDeserializer<T>(this.javaType, this.fields, this.fold);
        Iterator iterator = ((Iterable)this.fields).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            InjectField field = (InjectField)iterator.next();
            Map<String, ElementDeserializer> map = deserializer.deserializers;
            String string = field.getFieldName();
            JavaType javaType = ctxt.getContextualType().containedTypeOrUnknown(index);
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"containedTypeOrUnknown(...)");
            ElementDeserializer elementDeserializer = ElementDeserializer.Companion.resolve(javaType, ctxt, property);
            map.put(string, elementDeserializer);
        }
        return (ValueDeserializer)deserializer;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B'\bF\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0015\u0010\u0003\u001a\u00020\u0004X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00028\u00010\u0006X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Larrow/integrations/jackson/module/internal/ProductTypeDeserializer$InjectField;", "T", "", "fieldName", "", "point", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getFieldName", "()Ljava/lang/String;", "getPoint", "()Lkotlin/jvm/functions/Function1;", "arrow-core-jackson"})
    public static final class InjectField<T> {
        @NotNull
        private final String fieldName;
        @NotNull
        private final Function1<Object, T> point;

        public InjectField(@NotNull String fieldName, @NotNull Function1<Object, ? extends T> point) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(point, (String)"point");
            this.fieldName = fieldName;
            this.point = point;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        @NotNull
        public final Function1<Object, T> getPoint() {
            return this.point;
        }
    }
}

