/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module;

import arrow.core.NonEmptyList;
import arrow.core.NonEmptySet;
import arrow.integrations.jackson.module.NonEmptyCollectionDeserializer;
import arrow.integrations.jackson.module.NonEmptyCollectionDeserializerResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.type.CollectionType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J@\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Larrow/integrations/jackson/module/NonEmptyCollectionDeserializerResolver;", "Ltools/jackson/databind/deser/Deserializers$Base;", "<init>", "()V", "hasDeserializerFor", "", "config", "Ltools/jackson/databind/DeserializationConfig;", "valueType", "Ljava/lang/Class;", "findCollectionDeserializer", "Ltools/jackson/databind/ValueDeserializer;", "type", "Ltools/jackson/databind/type/CollectionType;", "beanDescRef", "Ltools/jackson/databind/BeanDescription$Supplier;", "elementTypeDeserializer", "Ltools/jackson/databind/jsontype/TypeDeserializer;", "elementDeserializer", "arrow-core-jackson"})
public final class NonEmptyCollectionDeserializerResolver
extends Deserializers.Base {
    @NotNull
    public static final NonEmptyCollectionDeserializerResolver INSTANCE = new NonEmptyCollectionDeserializerResolver();

    private NonEmptyCollectionDeserializerResolver() {
    }

    public boolean hasDeserializerFor(@NotNull DeserializationConfig config, @NotNull Class<?> valueType) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        return NonEmptyList.class.isAssignableFrom(valueType) || NonEmptySet.class.isAssignableFrom(valueType);
    }

    @Nullable
    public ValueDeserializer<?> findCollectionDeserializer(@NotNull CollectionType type, @NotNull DeserializationConfig config, @Nullable BeanDescription.Supplier beanDescRef, @Nullable TypeDeserializer elementTypeDeserializer, @Nullable ValueDeserializer<?> elementDeserializer) {
        ValueDeserializer valueDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (NonEmptyList.class.isAssignableFrom(type.getRawClass())) {
            JavaType javaType = type.getContentType();
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"getContentType(...)");
            valueDeserializer = (ValueDeserializer)new NonEmptyCollectionDeserializer<NonEmptyList>(javaType, NonEmptyList.class, findCollectionDeserializer.1.INSTANCE);
        } else if (NonEmptySet.class.isAssignableFrom(type.getRawClass())) {
            JavaType javaType = type.getContentType();
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"getContentType(...)");
            valueDeserializer = (ValueDeserializer)new NonEmptyCollectionDeserializer<NonEmptySet>(javaType, NonEmptySet.class, findCollectionDeserializer.2.INSTANCE);
        } else {
            valueDeserializer = null;
        }
        return valueDeserializer;
    }
}

