/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.integrations.jackson.module.internal.UnionTypeDeserializer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.Deserializers;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\bF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J(\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000f\u0010\u0002\u001a\u00020\u0003X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0004\u001a\u00020\u0003X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Larrow/integrations/jackson/module/EitherDeserializerResolver;", "Ltools/jackson/databind/deser/Deserializers$Base;", "leftFieldName", "", "rightFieldName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "hasDeserializerFor", "", "config", "Ltools/jackson/databind/DeserializationConfig;", "valueType", "Ljava/lang/Class;", "findBeanDeserializer", "Ltools/jackson/databind/ValueDeserializer;", "type", "Ltools/jackson/databind/JavaType;", "beanDesc", "Ltools/jackson/databind/BeanDescription$Supplier;", "arrow-core-jackson"})
public final class EitherDeserializerResolver
extends Deserializers.Base {
    @NotNull
    private final String leftFieldName;
    @NotNull
    private final String rightFieldName;

    public EitherDeserializerResolver(@NotNull String leftFieldName, @NotNull String rightFieldName) {
        Intrinsics.checkNotNullParameter((Object)leftFieldName, (String)"leftFieldName");
        Intrinsics.checkNotNullParameter((Object)rightFieldName, (String)"rightFieldName");
        this.leftFieldName = leftFieldName;
        this.rightFieldName = rightFieldName;
    }

    public boolean hasDeserializerFor(@NotNull DeserializationConfig config, @NotNull Class<?> valueType) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        return Either.class.isAssignableFrom(valueType);
    }

    @Nullable
    public ValueDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @NotNull DeserializationConfig config, @Nullable BeanDescription.Supplier beanDesc) {
        ValueDeserializer valueDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (Either.class.isAssignableFrom(type.getRawClass())) {
            Object[] objectArray = new UnionTypeDeserializer.InjectField[]{new UnionTypeDeserializer.InjectField(this.leftFieldName, EitherDeserializerResolver::findBeanDeserializer$lambda$0), new UnionTypeDeserializer.InjectField(this.rightFieldName, EitherDeserializerResolver::findBeanDeserializer$lambda$1)};
            valueDeserializer = (ValueDeserializer)new UnionTypeDeserializer(type, CollectionsKt.listOf((Object[])objectArray));
        } else {
            valueDeserializer = null;
        }
        return valueDeserializer;
    }

    private static final Either findBeanDeserializer$lambda$0(Object leftValue) {
        return EitherKt.left((Object)leftValue);
    }

    private static final Either findBeanDeserializer$lambda$1(Object rightValue) {
        return EitherKt.right((Object)rightValue);
    }
}

