/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module;

import arrow.core.NonEmptyCollection;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Larrow/integrations/jackson/module/NonEmptyCollectionDeserializer;", "T", "Larrow/core/NonEmptyCollection;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "contentType", "Lcom/fasterxml/jackson/databind/JavaType;", "klass", "Ljava/lang/Class;", "converter", "Lkotlin/Function1;", "", "<init>", "(Lcom/fasterxml/jackson/databind/JavaType;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Larrow/core/NonEmptyCollection;", "arrow-core-jackson"})
public final class NonEmptyCollectionDeserializer<T extends NonEmptyCollection<?>>
extends StdDeserializer<T> {
    @NotNull
    private final JavaType contentType;
    @NotNull
    private final Function1<List<?>, T> converter;

    public NonEmptyCollectionDeserializer(@NotNull JavaType contentType, @NotNull Class<T> klass, @NotNull Function1<? super List<?>, ? extends T> converter) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        super(klass);
        this.contentType = contentType;
        this.converter = converter;
    }

    @Nullable
    public T deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        CollectionType collection = CollectionType.construct(ArrayList.class, (JavaType)this.contentType);
        Object object = ctxt.readValue(p, (JavaType)collection);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (T)((NonEmptyCollection)this.converter.invoke(object));
    }
}

