/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.integrations.jackson.module.internal.UnionTypeDeserializer;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Larrow/integrations/jackson/module/EitherDeserializerResolver;", "Lcom/fasterxml/jackson/databind/deser/Deserializers$Base;", "leftFieldName", "", "rightFieldName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "findBeanDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "arrow-core-jackson"})
public final class EitherDeserializerResolver
extends Deserializers.Base {
    @NotNull
    private final String leftFieldName;
    @NotNull
    private final String rightFieldName;

    public EitherDeserializerResolver(@NotNull String leftFieldName, @NotNull String rightFieldName) {
        Intrinsics.checkNotNullParameter((Object)leftFieldName, (String)"leftFieldName");
        Intrinsics.checkNotNullParameter((Object)rightFieldName, (String)"rightFieldName");
        this.leftFieldName = leftFieldName;
        this.rightFieldName = rightFieldName;
    }

    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @NotNull DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (Either.class.isAssignableFrom(type.getRawClass())) {
            Object[] objectArray = new UnionTypeDeserializer.InjectField[]{new UnionTypeDeserializer.InjectField(this.leftFieldName, EitherDeserializerResolver::findBeanDeserializer$lambda$0), new UnionTypeDeserializer.InjectField(this.rightFieldName, EitherDeserializerResolver::findBeanDeserializer$lambda$1)};
            jsonDeserializer = (JsonDeserializer)new UnionTypeDeserializer<Either>(Either.class, type, CollectionsKt.listOf((Object[])objectArray));
        } else {
            jsonDeserializer = null;
        }
        return jsonDeserializer;
    }

    private static final Either findBeanDeserializer$lambda$0(Object leftValue) {
        return EitherKt.left((Object)leftValue);
    }

    private static final Either findBeanDeserializer$lambda$1(Object rightValue) {
        return EitherKt.right((Object)rightValue);
    }
}

