/*
 * Decompiled with CFR 0.152.
 */
package io.arkitik.tracker.core;

import io.arkitik.tracker.core.config.TrackerConfig;
import io.arkitik.tracker.core.contract.TrackerVerifier;
import io.arkitik.tracker.core.executer.TrackerExecutor;
import io.arkitik.tracker.core.filter.TrackerRequestFilter;
import io.arkitik.tracker.core.impl.DefaultTrackerConfigProvider;
import io.arkitik.tracker.core.impl.DefaultTrackerVerifier;
import io.arkitik.tracker.core.impl.EmptyTrackerExecutor;
import io.arkitik.tracker.core.provider.TrackerConfigProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Configuration
@EnableConfigurationProperties(value={TrackerConfig.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0011"}, d2={"Lio/arkitik/tracker/core/TrackerConfiguration;", "", "()V", "pathMatcher", "Lorg/springframework/util/PathMatcher;", "trackerConfigProvider", "Lio/arkitik/tracker/core/provider/TrackerConfigProvider;", "trackerConfig", "Lio/arkitik/tracker/core/config/TrackerConfig;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "trackerExecutor", "Lio/arkitik/tracker/core/executer/TrackerExecutor;", "trackerRequestFilter", "Lio/arkitik/tracker/core/filter/TrackerRequestFilter;", "trackerVerifier", "Lio/arkitik/tracker/core/contract/TrackerVerifier;", "tracker-core"})
public class TrackerConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PathMatcher.class})
    @NotNull
    public PathMatcher pathMatcher() {
        return (PathMatcher)new AntPathMatcher();
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackerExecutor.class})
    @NotNull
    public TrackerExecutor trackerExecutor() {
        return new EmptyTrackerExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackerConfigProvider.class})
    @NotNull
    public TrackerConfigProvider trackerConfigProvider(@NotNull TrackerConfig trackerConfig, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)trackerConfig, (String)"trackerConfig");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return new DefaultTrackerConfigProvider(trackerConfig, applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackerVerifier.class})
    @NotNull
    public TrackerVerifier trackerVerifier(@NotNull TrackerConfigProvider trackerConfigProvider, @NotNull PathMatcher pathMatcher) {
        Intrinsics.checkNotNullParameter((Object)trackerConfigProvider, (String)"trackerConfigProvider");
        Intrinsics.checkNotNullParameter((Object)pathMatcher, (String)"pathMatcher");
        return new DefaultTrackerVerifier(trackerConfigProvider, pathMatcher);
    }

    @Bean
    @NotNull
    public TrackerRequestFilter trackerRequestFilter(@NotNull TrackerExecutor trackerExecutor, @NotNull TrackerVerifier trackerVerifier) {
        Intrinsics.checkNotNullParameter((Object)trackerExecutor, (String)"trackerExecutor");
        Intrinsics.checkNotNullParameter((Object)trackerVerifier, (String)"trackerVerifier");
        return new TrackerRequestFilter(trackerExecutor, trackerVerifier);
    }
}

