/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.protobuf.nano;

import io.appmetrica.analytics.protobuf.nano.MessageNano;
import io.appmetrica.analytics.protobuf.nano.WireFormatNano;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class CodedOutputByteBufferNano {
    private static final int MAX_UTF8_EXPANSION = 3;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;
    private final ByteBuffer buffer;

    private CodedOutputByteBufferNano(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private CodedOutputByteBufferNano(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static CodedOutputByteBufferNano newInstance(byte[] byArray) {
        return CodedOutputByteBufferNano.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputByteBufferNano newInstance(byte[] byArray, int n, int n2) {
        return new CodedOutputByteBufferNano(byArray, n, n2);
    }

    private static int encodedLength(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        int n3 = n2;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                ++n;
                continue;
            }
            n3 += CodedOutputByteBufferNano.encodedLengthGeneral(charSequence, n);
            break;
        }
        if (n3 >= n2) {
            return n3;
        }
        throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += 2;
                if ('\ud800' <= c && c <= '\udfff') {
                    if (Character.codePointAt(charSequence, n) >= 65536) {
                        ++n;
                    } else {
                        throw new IllegalArgumentException("Unpaired surrogate at index " + n);
                    }
                }
            }
            ++n;
        }
        return n3;
    }

    private static void encode(CharSequence object, ByteBuffer byteBuffer) {
        block6: {
            block8: {
                block7: {
                    ByteBuffer byteBuffer2;
                    ByteBuffer byteBuffer3;
                    CharSequence charSequence;
                    ByteBuffer byteBuffer4;
                    if (byteBuffer.isReadOnly()) break block6;
                    if (!byteBuffer.hasArray()) break block7;
                    try {
                        byteBuffer4 = byteBuffer;
                        charSequence = object;
                        ByteBuffer byteBuffer5 = byteBuffer;
                        byteBuffer3 = byteBuffer5;
                        byteBuffer2 = byteBuffer5;
                        object = byteBuffer5.array();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        BufferOverflowException bufferOverflowException = new BufferOverflowException();
                        bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                        throw bufferOverflowException;
                    }
                    int n = byteBuffer2.arrayOffset() + byteBuffer.position();
                    int n2 = byteBuffer3.remaining();
                    int n3 = CodedOutputByteBufferNano.encode(charSequence, (byte[])object, n, n2) - byteBuffer.arrayOffset();
                    byteBuffer4.position(n3);
                    break block8;
                }
                CodedOutputByteBufferNano.encodeDirect((CharSequence)object, byteBuffer);
            }
            return;
        }
        throw new ReadOnlyBufferException();
    }

    private static void encodeDirect(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c < '\u0800') {
                byteBuffer.put((byte)(c >>> 6 | 0x3C0));
                byteBuffer.put((byte)(c & 0x3F | 0x80));
                continue;
            }
            if (c >= '\ud800' && '\udfff' >= c) {
                int n2 = i + 1;
                if (n2 != charSequence.length()) {
                    char c2 = charSequence.charAt(n2);
                    i = c2;
                    if (Character.isSurrogatePair(c, c2)) {
                        i = Character.toCodePoint(c, (char)i);
                        byteBuffer.put((byte)(i >>> 18 | 0xF0));
                        byteBuffer.put((byte)(i >>> 12 & 0x3F | 0x80));
                        byteBuffer.put((byte)(i >>> 6 & 0x3F | 0x80));
                        byteBuffer.put((byte)(i & 0x3F | 0x80));
                        i = n2;
                        continue;
                    }
                    i = n2;
                }
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            byteBuffer.put((byte)(c >>> 12 | 0x1E0));
            byteBuffer.put((byte)(c >>> 6 & 0x3F | 0x80));
            byteBuffer.put((byte)(c & 0x3F | 0x80));
        }
    }

    private static int encode(CharSequence charSequence, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = charSequence.length();
        n2 = n + n2;
        for (n5 = 0; n5 < n6 && (n4 = n5 + n) < n2 && (n3 = charSequence.charAt(n5)) < 128; ++n5) {
            byArray[n4] = (byte)n3;
        }
        if (n5 == n6) {
            return n + n6;
        }
        n += n5;
        while (n5 < n6) {
            block10: {
                block11: {
                    block12: {
                        block7: {
                            block9: {
                                block8: {
                                    block6: {
                                        char c = charSequence.charAt(n5);
                                        n4 = c;
                                        if (c >= '\u0080' || n >= n2) break block6;
                                        int n7 = n4;
                                        n4 = n + 1;
                                        byArray[n] = (byte)n7;
                                        n = n4;
                                        break block7;
                                    }
                                    if (n4 >= 2048 || n > n2 - 2) break block8;
                                    int n8 = n4;
                                    int n9 = n4;
                                    n4 = n + 1;
                                    byArray[n] = (byte)(n9 >>> 6 | 0x3C0);
                                    n += 2;
                                    byArray[n4] = (byte)(n8 & 0x3F | 0x80);
                                    break block7;
                                }
                                if (n4 >= 55296 && 57343 >= n4 || n > n2 - 3) break block9;
                                int n10 = n4;
                                int n11 = n4;
                                int n12 = n4;
                                n4 = n + 1;
                                byArray[n] = (byte)(n12 >>> 12 | 0x1E0);
                                n3 = n + 2;
                                byArray[n4] = (byte)(n11 >>> 6 & 0x3F | 0x80);
                                n += 3;
                                byArray[n3] = (byte)(n10 & 0x3F | 0x80);
                                break block7;
                            }
                            if (n > n2 - 4) break block10;
                            n3 = n5 + 1;
                            if (n3 == charSequence.length()) break block11;
                            char c = charSequence.charAt(n3);
                            n5 = c;
                            if (!Character.isSurrogatePair((char)n4, c)) break block12;
                            int n13 = Character.toCodePoint((char)n4, (char)n5);
                            int n14 = n5 = n13;
                            int n15 = n5;
                            int n16 = n5;
                            n5 = n + 1;
                            byArray[n] = (byte)(n16 >>> 18 | 0xF0);
                            n4 = n + 2;
                            byArray[n5] = (byte)(n15 >>> 12 & 0x3F | 0x80);
                            n5 = n + 3;
                            byArray[n4] = (byte)(n14 >>> 6 & 0x3F | 0x80);
                            n += 4;
                            byArray[n5] = (byte)(n13 & 0x3F | 0x80);
                            n5 = n3;
                        }
                        ++n5;
                        continue;
                    }
                    n5 = n3;
                }
                throw new IllegalArgumentException("Unpaired surrogate at index " + (n5 - 1));
            }
            throw new ArrayIndexOutOfBoundsException("Failed writing " + (char)n4 + " at index " + n);
        }
        return n;
    }

    public static int computeDoubleSize(int n, double d) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeDoubleSizeNoTag(d) + n;
    }

    public static int computeFloatSize(int n, float f) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeFloatSizeNoTag(f) + n;
    }

    public static int computeUInt64Size(int n, long l) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeUInt64SizeNoTag(l) + n;
    }

    public static int computeInt64Size(int n, long l) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeInt64SizeNoTag(l) + n;
    }

    public static int computeInt32Size(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeInt32SizeNoTag(n2) + n;
    }

    public static int computeFixed64Size(int n, long l) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeFixed64SizeNoTag(l) + n;
    }

    public static int computeFixed32Size(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeFixed32SizeNoTag(n2) + n;
    }

    public static int computeBoolSize(int n, boolean bl) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeBoolSizeNoTag(bl) + n;
    }

    public static int computeStringSize(int n, String string) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeStringSizeNoTag(string) + n;
    }

    public static int computeGroupSize(int n, MessageNano messageNano) {
        n = CodedOutputByteBufferNano.computeTagSize(n) * 2;
        return CodedOutputByteBufferNano.computeGroupSizeNoTag(messageNano) + n;
    }

    public static int computeMessageSize(int n, MessageNano messageNano) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeMessageSizeNoTag(messageNano) + n;
    }

    public static int computeBytesSize(int n, byte[] byArray) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeBytesSizeNoTag(byArray) + n;
    }

    public static int computeUInt32Size(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeUInt32SizeNoTag(n2) + n;
    }

    public static int computeEnumSize(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeEnumSizeNoTag(n2) + n;
    }

    public static int computeSFixed32Size(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeSFixed32SizeNoTag(n2) + n;
    }

    public static int computeSFixed64Size(int n, long l) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeSFixed64SizeNoTag(l) + n;
    }

    public static int computeSInt32Size(int n, int n2) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeSInt32SizeNoTag(n2) + n;
    }

    public static int computeSInt64Size(int n, long l) {
        n = CodedOutputByteBufferNano.computeTagSize(n);
        return CodedOutputByteBufferNano.computeSInt64SizeNoTag(l) + n;
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long l) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(l);
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputByteBufferNano.computeRawVarint32Size(n);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeStringSizeNoTag(String string) {
        int n = CodedOutputByteBufferNano.encodedLength(string);
        return CodedOutputByteBufferNano.computeRawVarint32Size(n) + n;
    }

    public static int computeGroupSizeNoTag(MessageNano messageNano) {
        return messageNano.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(MessageNano messageNano) {
        int n = messageNano.getSerializedSize();
        return CodedOutputByteBufferNano.computeRawVarint32Size(n) + n;
    }

    public static int computeBytesSizeNoTag(byte[] byArray) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(byArray.length) + byArray.length;
    }

    public static int computeUInt32SizeNoTag(int n) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(n);
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(n);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(CodedOutputByteBufferNano.encodeZigZag32(n));
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputByteBufferNano.computeRawVarint64Size(CodedOutputByteBufferNano.encodeZigZag64(l));
    }

    public static int computeTagSize(int n) {
        return CodedOutputByteBufferNano.computeRawVarint32Size(WireFormatNano.makeTag(n, 0));
    }

    public static int computeRawVarint32Size(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarint64Size(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    static int computeFieldSize(int n, int n2, Object object) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("Unknown type: " + n2);
            }
            case 18: {
                return CodedOutputByteBufferNano.computeSInt64Size(n, (Long)object);
            }
            case 17: {
                return CodedOutputByteBufferNano.computeSInt32Size(n, (Integer)object);
            }
            case 16: {
                return CodedOutputByteBufferNano.computeSFixed64Size(n, (Long)object);
            }
            case 15: {
                return CodedOutputByteBufferNano.computeSFixed32Size(n, (Integer)object);
            }
            case 14: {
                return CodedOutputByteBufferNano.computeEnumSize(n, (Integer)object);
            }
            case 13: {
                return CodedOutputByteBufferNano.computeUInt32Size(n, (Integer)object);
            }
            case 12: {
                return CodedOutputByteBufferNano.computeBytesSize(n, (byte[])object);
            }
            case 11: {
                return CodedOutputByteBufferNano.computeMessageSize(n, (MessageNano)object);
            }
            case 10: {
                return CodedOutputByteBufferNano.computeGroupSize(n, (MessageNano)object);
            }
            case 9: {
                return CodedOutputByteBufferNano.computeStringSize(n, (String)object);
            }
            case 8: {
                return CodedOutputByteBufferNano.computeBoolSize(n, (Boolean)object);
            }
            case 7: {
                return CodedOutputByteBufferNano.computeFixed32Size(n, (Integer)object);
            }
            case 6: {
                return CodedOutputByteBufferNano.computeFixed64Size(n, (Long)object);
            }
            case 5: {
                return CodedOutputByteBufferNano.computeInt32Size(n, (Integer)object);
            }
            case 4: {
                return CodedOutputByteBufferNano.computeUInt64Size(n, (Long)object);
            }
            case 3: {
                return CodedOutputByteBufferNano.computeInt64Size(n, (Long)object);
            }
            case 2: {
                return CodedOutputByteBufferNano.computeFloatSize(n, ((Float)object).floatValue());
            }
            case 1: 
        }
        return CodedOutputByteBufferNano.computeDoubleSize(n, (Double)object);
    }

    public void writeDouble(int n, double d) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 1);
        codedOutputByteBufferNano.writeDoubleNoTag(d);
    }

    public void writeFloat(int n, float f) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 5);
        codedOutputByteBufferNano.writeFloatNoTag(f);
    }

    public void writeUInt64(int n, long l) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeUInt64NoTag(l);
    }

    public void writeInt64(int n, long l) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeInt64NoTag(l);
    }

    public void writeInt32(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeInt32NoTag(n2);
    }

    public void writeFixed64(int n, long l) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 1);
        codedOutputByteBufferNano.writeFixed64NoTag(l);
    }

    public void writeFixed32(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 5);
        codedOutputByteBufferNano.writeFixed32NoTag(n2);
    }

    public void writeBool(int n, boolean bl) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeBoolNoTag(bl);
    }

    public void writeString(int n, String string) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 2);
        codedOutputByteBufferNano.writeStringNoTag(string);
    }

    public void writeGroup(int n, MessageNano messageNano) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 3);
        codedOutputByteBufferNano.writeGroupNoTag(messageNano);
        codedOutputByteBufferNano.writeTag(n, 4);
    }

    public void writeMessage(int n, MessageNano messageNano) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 2);
        codedOutputByteBufferNano.writeMessageNoTag(messageNano);
    }

    public void writeBytes(int n, byte[] byArray) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 2);
        codedOutputByteBufferNano.writeBytesNoTag(byArray);
    }

    public void writeUInt32(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeUInt32NoTag(n2);
    }

    public void writeEnum(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeEnumNoTag(n2);
    }

    public void writeSFixed32(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 5);
        codedOutputByteBufferNano.writeSFixed32NoTag(n2);
    }

    public void writeSFixed64(int n, long l) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 1);
        codedOutputByteBufferNano.writeSFixed64NoTag(l);
    }

    public void writeSInt32(int n, int n2) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeSInt32NoTag(n2);
    }

    public void writeSInt64(int n, long l) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeTag(n, 0);
        codedOutputByteBufferNano.writeSInt64NoTag(l);
    }

    public void writeDoubleNoTag(double d) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToLongBits(d));
    }

    public void writeFloatNoTag(float f) throws IOException {
        this.writeRawLittleEndian32(Float.floatToIntBits(f));
    }

    public void writeUInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(l);
    }

    public void writeInt32NoTag(int n) throws IOException {
        if (n >= 0) {
            this.writeRawVarint32(n);
        } else {
            this.writeRawVarint64(n);
        }
    }

    public void writeFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeBoolNoTag(boolean bl) throws IOException {
        this.writeRawByte(bl ? 1 : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeStringNoTag(String string) throws IOException {
        BufferOverflowException bufferOverflowException2;
        block11: {
            block9: {
                int n;
                int n2;
                block10: {
                    CodedOutputByteBufferNano codedOutputByteBufferNano;
                    String string2;
                    CodedOutputByteBufferNano codedOutputByteBufferNano2;
                    CodedOutputByteBufferNano codedOutputByteBufferNano3;
                    CodedOutputByteBufferNano codedOutputByteBufferNano4;
                    try {
                        n2 = CodedOutputByteBufferNano.computeRawVarint32Size(string.length());
                        if (n2 != CodedOutputByteBufferNano.computeRawVarint32Size(string.length() * 3)) break block9;
                        CodedOutputByteBufferNano codedOutputByteBufferNano5 = this;
                        n = codedOutputByteBufferNano5.buffer.position();
                        if (codedOutputByteBufferNano5.buffer.remaining() < n2) break block10;
                        CodedOutputByteBufferNano codedOutputByteBufferNano6 = this;
                        codedOutputByteBufferNano4 = codedOutputByteBufferNano6;
                        codedOutputByteBufferNano3 = codedOutputByteBufferNano6;
                        codedOutputByteBufferNano2 = codedOutputByteBufferNano6;
                        string2 = string;
                        CodedOutputByteBufferNano codedOutputByteBufferNano7 = this;
                        codedOutputByteBufferNano = codedOutputByteBufferNano7;
                        codedOutputByteBufferNano7.buffer.position(n + n2);
                    }
                    catch (BufferOverflowException bufferOverflowException2) {}
                    CodedOutputByteBufferNano.encode(string2, codedOutputByteBufferNano.buffer);
                    int n3 = codedOutputByteBufferNano3.buffer.position();
                    int n4 = n;
                    this.buffer.position(n);
                    codedOutputByteBufferNano2.writeRawVarint32(n3 - n4 - n2);
                    codedOutputByteBufferNano4.buffer.position(n3);
                    return;
                }
                throw new OutOfSpaceException(n + n2, this.buffer.limit());
                break block11;
            }
            CodedOutputByteBufferNano codedOutputByteBufferNano = this;
            codedOutputByteBufferNano.writeRawVarint32(CodedOutputByteBufferNano.encodedLength(string));
            CodedOutputByteBufferNano.encode(string, codedOutputByteBufferNano.buffer);
            return;
        }
        OutOfSpaceException outOfSpaceException = new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
        outOfSpaceException.initCause(bufferOverflowException2);
        throw outOfSpaceException;
    }

    public void writeGroupNoTag(MessageNano messageNano) throws IOException {
        messageNano.writeTo(this);
    }

    public void writeMessageNoTag(MessageNano messageNano) throws IOException {
        CodedOutputByteBufferNano codedOutputByteBufferNano = this;
        codedOutputByteBufferNano.writeRawVarint32(messageNano.getCachedSize());
        messageNano.writeTo(codedOutputByteBufferNano);
    }

    public void writeBytesNoTag(byte[] byArray) throws IOException {
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeUInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeEnumNoTag(int n) throws IOException {
        this.writeRawVarint32(n);
    }

    public void writeSFixed32NoTag(int n) throws IOException {
        this.writeRawLittleEndian32(n);
    }

    public void writeSFixed64NoTag(long l) throws IOException {
        this.writeRawLittleEndian64(l);
    }

    public void writeSInt32NoTag(int n) throws IOException {
        this.writeRawVarint32(CodedOutputByteBufferNano.encodeZigZag32(n));
    }

    public void writeSInt64NoTag(long l) throws IOException {
        this.writeRawVarint64(CodedOutputByteBufferNano.encodeZigZag64(l));
    }

    public int spaceLeft() {
        return this.buffer.remaining();
    }

    public void checkNoSpaceLeft() {
        if (this.spaceLeft() == 0) {
            return;
        }
        throw new IllegalStateException("Did not write as much data as expected.");
    }

    public int position() {
        return this.buffer.position();
    }

    public void reset() {
        this.buffer.clear();
    }

    public void writeRawByte(byte by) throws IOException {
        if (this.buffer.hasRemaining()) {
            this.buffer.put(by);
            return;
        }
        throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
    }

    public void writeRawByte(int n) throws IOException {
        this.writeRawByte((byte)n);
    }

    public void writeRawBytes(byte[] byArray) throws IOException {
        int n = byArray.length;
        this.writeRawBytes(byArray, 0, n);
    }

    public void writeRawBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer.remaining() >= n2) {
            this.buffer.put(byArray, n, n2);
            return;
        }
        throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
    }

    public void writeTag(int n, int n2) throws IOException {
        this.writeRawVarint32(WireFormatNano.makeTag(n, n2));
    }

    public void writeRawVarint32(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeRawByte(n);
                return;
            }
            this.writeRawByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public void writeRawVarint64(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l);
                return;
            }
            this.writeRawByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public void writeRawLittleEndian32(int n) throws IOException {
        if (this.buffer.remaining() >= 4) {
            this.buffer.putInt(n);
            return;
        }
        throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
    }

    public void writeRawLittleEndian64(long l) throws IOException {
        if (this.buffer.remaining() >= 8) {
            this.buffer.putLong(l);
            return;
        }
        throw new OutOfSpaceException(this.buffer.position(), this.buffer.limit());
    }

    void writeField(int n, int n2, Object object) throws IOException {
        switch (n2) {
            default: {
                throw new IOException("Unknown type: " + n2);
            }
            case 18: {
                this.writeSInt64(n, (Long)object);
                break;
            }
            case 17: {
                this.writeSInt32(n, (Integer)object);
                break;
            }
            case 16: {
                this.writeSFixed64(n, (Long)object);
                break;
            }
            case 15: {
                this.writeSFixed32(n, (Integer)object);
                break;
            }
            case 14: {
                this.writeEnum(n, (Integer)object);
                break;
            }
            case 13: {
                this.writeUInt32(n, (Integer)object);
                break;
            }
            case 12: {
                this.writeBytes(n, (byte[])object);
                break;
            }
            case 11: {
                this.writeMessage(n, (MessageNano)object);
                break;
            }
            case 10: {
                this.writeGroup(n, (MessageNano)object);
                break;
            }
            case 9: {
                this.writeString(n, (String)object);
                break;
            }
            case 8: {
                this.writeBool(n, (Boolean)object);
                break;
            }
            case 7: {
                this.writeFixed32(n, (Integer)object);
                break;
            }
            case 6: {
                this.writeFixed64(n, (Long)object);
                break;
            }
            case 5: {
                this.writeInt32(n, (Integer)object);
                break;
            }
            case 4: {
                this.writeUInt64(n, (Long)object);
                break;
            }
            case 3: {
                this.writeInt64(n, (Long)object);
                break;
            }
            case 2: {
                this.writeFloat(n, ((Float)object).floatValue());
                break;
            }
            case 1: {
                this.writeDouble(n, (Double)object);
            }
        }
    }

    public static class OutOfSpaceException
    extends IOException {
        private static final long serialVersionUID = -6947486886997889499L;

        OutOfSpaceException(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

