/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal.parsing;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u001b\u0010\t\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\n\u001a%\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\f\u001a\u001c\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000e\u001a\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010\u001a\u001c\u0010\u0011\u001a\u00020\u0004*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a%\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0018\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u001b"}, d2={"isEqualTo", "", "Lorg/json/JSONArray;", "value", "Lorg/json/JSONObject;", "optBooleanOrDefault", "key", "", "fallback", "optBooleanOrNull", "(Lorg/json/JSONObject;Ljava/lang/String;)Ljava/lang/Boolean;", "optBooleanOrNullable", "(Lorg/json/JSONObject;Ljava/lang/String;Ljava/lang/Boolean;)Ljava/lang/Boolean;", "optFloatOrDefault", "", "optFloatOrNull", "(Lorg/json/JSONObject;Ljava/lang/String;)Ljava/lang/Float;", "optJsonObjectOrDefault", "optJsonObjectOrNull", "optJsonObjectOrNullable", "optLongOrDefault", "", "(Lorg/json/JSONObject;Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/Long;", "optLongOrNull", "(Lorg/json/JSONObject;Ljava/lang/String;)Ljava/lang/Long;", "optStringOrNull", "optStringOrNullable", "core-utils_release"})
@JvmName(name="JsonUtils")
public final class JsonUtils {
    @Nullable
    public static final Long optLongOrDefault(@Nullable JSONObject object, @NotNull String string, @Nullable Long l) {
        if ((object = JsonUtils.optLongOrNull(object, string)) != null) {
            l = object;
        }
        return l;
    }

    @Nullable
    public static final Long optLongOrNull(@Nullable JSONObject jSONObject, @NotNull String string) {
        if (jSONObject != null && jSONObject.has(string)) {
            try {
                return jSONObject.getLong(string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static final float optFloatOrDefault(@Nullable JSONObject object, @NotNull String string, float f2) {
        if ((object = JsonUtils.optFloatOrNull((JSONObject)object, string)) != null) {
            f2 = ((Float)object).floatValue();
        }
        return f2;
    }

    @Nullable
    public static final Float optFloatOrNull(@Nullable JSONObject jSONObject, @NotNull String string) {
        if (jSONObject != null && jSONObject.has(string)) {
            float f2;
            try {
                f2 = (float)jSONObject.getDouble(string);
            }
            catch (Throwable throwable) {}
            return Float.valueOf(f2);
        }
        return null;
    }

    @Nullable
    public static final String optStringOrNullable(@Nullable JSONObject object, @NotNull String string, @Nullable String string2) {
        if ((object = JsonUtils.optStringOrNull(object, string)) != null) {
            string2 = object;
        }
        return string2;
    }

    @Nullable
    public static final String optStringOrNull(@Nullable JSONObject jSONObject, @NotNull String string) {
        if (jSONObject != null && jSONObject.has(string)) {
            try {
                return jSONObject.getString(string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static final boolean optBooleanOrDefault(@Nullable JSONObject object, @NotNull String string, boolean bl) {
        if ((object = JsonUtils.optBooleanOrNull((JSONObject)object, string)) != null) {
            bl = (Boolean)object;
        }
        return bl;
    }

    @Nullable
    public static final Boolean optBooleanOrNullable(@Nullable JSONObject object, @NotNull String string, @Nullable Boolean bl) {
        if ((object = JsonUtils.optBooleanOrNull(object, string)) != null) {
            bl = object;
        }
        return bl;
    }

    @Nullable
    public static final Boolean optBooleanOrNull(@Nullable JSONObject jSONObject, @NotNull String string) {
        if (jSONObject != null && jSONObject.has(string)) {
            try {
                return jSONObject.getBoolean(string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @NotNull
    public static final JSONObject optJsonObjectOrDefault(@Nullable JSONObject jSONObject, @NotNull String string, @NotNull JSONObject jSONObject2) {
        if ((jSONObject = JsonUtils.optJsonObjectOrNull(jSONObject, string)) != null) {
            jSONObject2 = jSONObject;
        }
        return jSONObject2;
    }

    @Nullable
    public static final JSONObject optJsonObjectOrNullable(@Nullable JSONObject jSONObject, @NotNull String string, @Nullable JSONObject jSONObject2) {
        if ((jSONObject = JsonUtils.optJsonObjectOrNull(jSONObject, string)) != null) {
            jSONObject2 = jSONObject;
        }
        return jSONObject2;
    }

    @Nullable
    public static final JSONObject optJsonObjectOrNull(@Nullable JSONObject jSONObject, @NotNull String string) {
        return jSONObject != null ? jSONObject.optJSONObject(string) : null;
    }

    public static final boolean isEqualTo(@NotNull JSONObject jSONObject, @NotNull JSONObject jSONObject2) {
        boolean bl;
        block2: {
            if (!Intrinsics.areEqual((Object)SequencesKt.toSet((Sequence)SequencesKt.asSequence((Iterator)jSONObject.keys())), (Object)SequencesKt.toSet((Sequence)SequencesKt.asSequence((Iterator)jSONObject2.keys())))) {
                return false;
            }
            for (Object object : SequencesKt.asSequence((Iterator)jSONObject.keys())) {
                block4: {
                    boolean bl2;
                    block5: {
                        Object object2;
                        block6: {
                            block3: {
                                object2 = jSONObject.get((String)object);
                                object = jSONObject2.get((String)object);
                                if (!(object2 instanceof JSONObject)) break block3;
                                if (!(object instanceof JSONObject)) break block4;
                                bl2 = JsonUtils.isEqualTo((JSONObject)object2, (JSONObject)object);
                                break block5;
                            }
                            if (!(object2 instanceof JSONArray)) break block6;
                            if (!(object instanceof JSONArray)) break block4;
                            bl2 = JsonUtils.isEqualTo((JSONArray)object2, (JSONArray)object);
                            break block5;
                        }
                        bl2 = object2.equals(object);
                    }
                    if (bl2) continue;
                }
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEqualTo(@NotNull JSONArray jSONArray, @NotNull JSONArray jSONArray2) {
        boolean bl;
        if (jSONArray.length() != jSONArray2.length()) {
            return false;
        }
        Object object = RangesKt.until((int)0, (int)jSONArray.length());
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return true;
            int n = ((IntIterator)object).nextInt();
            Object object2 = jSONArray.get(n);
            Object object3 = jSONArray2.get(n);
            if (object2 instanceof JSONObject) {
                if (!(object3 instanceof JSONObject)) return false;
                bl = JsonUtils.isEqualTo((JSONObject)object2, (JSONObject)object3);
                continue;
            }
            if (object2 instanceof JSONArray) {
                if (!(object3 instanceof JSONArray)) return false;
                bl = JsonUtils.isEqualTo((JSONArray)object2, (JSONArray)object3);
                continue;
            }
            bl = object2.equals(object3);
        } while (bl);
        return false;
    }
}

