/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.appmetrica.analytics.coreapi.internal.cache.CacheUpdateScheduler;
import io.appmetrica.analytics.coreapi.internal.cache.UpdateConditionsChecker;
import io.appmetrica.analytics.coreutils.internal.cache.CachedDataProvider;

public abstract class DataCache<T>
implements UpdateConditionsChecker {
    @NonNull
    protected final CachedDataProvider.CachedData<T> mCachedData;
    private CacheUpdateScheduler a;

    public DataCache(long l, long l2, @NonNull String string) {
        CachedDataProvider.CachedData cachedData;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = string;
        String.format("[DataCache-%s]", object);
        object = cachedData;
        cachedData = new CachedDataProvider.CachedData(l, l2, string);
        object.mCachedData = object;
    }

    public void updateData(@NonNull T t) {
        if (dataCache2.shouldUpdate(t)) {
            DataCache dataCache = dataCache2;
            dataCache.mCachedData.setData(t);
            DataCache dataCache2 = dataCache.a;
            if (dataCache2 != null) {
                dataCache2.onStateUpdated();
            }
        }
    }

    @Nullable
    public T getData() {
        CacheUpdateScheduler cacheUpdateScheduler;
        if (this.shouldUpdate() && (cacheUpdateScheduler = this.a) != null) {
            cacheUpdateScheduler.scheduleUpdateIfNeededNow();
        }
        if (this.mCachedData.shouldClearData()) {
            this.mCachedData.setData(null);
        }
        return this.mCachedData.getData();
    }

    public void setUpdateScheduler(@NonNull CacheUpdateScheduler cacheUpdateScheduler) {
        this.a = cacheUpdateScheduler;
    }

    public void updateCacheControl(long l, long l2) {
        this.mCachedData.setExpirationPolicy(l, l2);
    }

    public boolean shouldUpdate() {
        return this.mCachedData.isEmpty() || this.mCachedData.shouldUpdateData();
    }

    protected abstract boolean shouldUpdate(@NonNull T var1);

    @VisibleForTesting
    @NonNull
    public CachedDataProvider.CachedData<T> getCachedData() {
        return this.mCachedData;
    }
}

