/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.appium.java_client.internal.ReflectionHelpers;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.ListOutputStream;
import io.appium.java_client.service.local.Slf4jLogMessageContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class AppiumDriverLocalService
extends DriverService {
    private static final String URL_MASK = "http://%s:%d/";
    private static final Logger LOG = LoggerFactory.getLogger(AppiumDriverLocalService.class);
    private static final Pattern LOGGER_CONTEXT_PATTERN = Pattern.compile("^(\\[debug\\] )?\\[(.+?)\\]");
    private static final String APPIUM_SERVICE_SLF4J_LOGGER_PREFIX = "appium.service";
    private static final Duration DESTROY_TIMEOUT = Duration.ofSeconds(60L);
    private final File nodeJSExec;
    private final List<String> nodeJSArgs;
    private final Map<String, String> nodeJSEnvironment;
    private final Duration startupTimeout;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ListOutputStream stream = new ListOutputStream().add(System.out);
    private final URL url;
    private String basePath;
    private CommandLine process = null;

    AppiumDriverLocalService(String ipAddress, File nodeJSExec, int nodeJSPort, Duration startupTimeout, List<String> nodeJSArgs, Map<String, String> nodeJSEnvironment) throws IOException {
        super(nodeJSExec, nodeJSPort, startupTimeout, nodeJSArgs, nodeJSEnvironment);
        this.nodeJSExec = nodeJSExec;
        this.nodeJSArgs = nodeJSArgs;
        this.nodeJSEnvironment = nodeJSEnvironment;
        this.startupTimeout = startupTimeout;
        this.url = new URL(String.format(URL_MASK, ipAddress, nodeJSPort));
    }

    public static AppiumDriverLocalService buildDefaultService() {
        return AppiumDriverLocalService.buildService(new AppiumServiceBuilder());
    }

    public static AppiumDriverLocalService buildService(AppiumServiceBuilder builder) {
        return (AppiumDriverLocalService)builder.build();
    }

    public AppiumDriverLocalService withBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    private static URL addSuffix(URL url, String suffix) {
        return url.toURI().resolve("." + (suffix.startsWith("/") ? suffix : "/" + suffix)).toURL();
    }

    private static URL replaceHost(URL source, String oldHost, String newHost) {
        return new URL(source.toString().replace(oldHost, newHost));
    }

    public URL getUrl() {
        return this.basePath == null ? this.url : AppiumDriverLocalService.addSuffix(this.url, this.basePath);
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            if (this.process == null || !this.process.isRunning()) {
                boolean bl = false;
                return bl;
            }
            this.ping(Duration.ofMillis(1500L));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ping(Duration timeout) throws UrlChecker.TimeoutException, MalformedURLException {
        URL status = AppiumDriverLocalService.addSuffix(AppiumDriverLocalService.replaceHost(this.getUrl(), "0.0.0.0", "127.0.0.1"), "/status");
        new UrlChecker().waitUntilAvailable(timeout.toMillis(), TimeUnit.MILLISECONDS, new URL[]{status});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws AppiumServerHasNotBeenStartedLocallyException {
        this.lock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            try {
                this.process = new CommandLine(this.nodeJSExec.getCanonicalPath(), this.nodeJSArgs.toArray(new String[0]));
                this.process.setEnvironmentVariables(this.nodeJSEnvironment);
                this.process.copyOutputTo((OutputStream)this.stream);
                this.process.executeAsync();
                this.ping(this.startupTimeout);
            }
            catch (Throwable e) {
                String processStream;
                this.destroyProcess();
                String msgTxt = "The local appium server has not been started. The given Node.js executable: " + this.nodeJSExec.getAbsolutePath() + " Arguments: " + this.nodeJSArgs.toString() + " \n";
                if (this.process != null && !StringUtils.isBlank((CharSequence)(processStream = this.process.getStdOut()))) {
                    msgTxt = msgTxt + "Process output: " + processStream + "\n";
                }
                throw new AppiumServerHasNotBeenStartedLocallyException(msgTxt, e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.process != null) {
                this.destroyProcess();
            }
            this.process = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int destroyProcess(Duration timeout) {
        if (this.process == null || !this.process.isRunning()) {
            return 0;
        }
        try {
            Object osProcess = ReflectionHelpers.getPrivateFieldValue(this.process.getClass(), this.process, "process", Object.class);
            Object watchdog = ReflectionHelpers.getPrivateFieldValue(osProcess.getClass(), osProcess, "executeWatchdog", Object.class);
            Process nativeProcess = ReflectionHelpers.getPrivateFieldValue(watchdog.getClass(), watchdog, "process", Process.class);
            nativeProcess.destroy();
            nativeProcess.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOG.warn("No explicit timeout could be applied to the process termination", (Throwable)e);
        }
        return this.process.destroy();
    }

    private void destroyProcess() {
        this.destroyProcess(DESTROY_TIMEOUT);
    }

    @Nullable
    public String getStdOut() {
        if (this.process != null) {
            return this.process.getStdOut();
        }
        return null;
    }

    public void addOutPutStream(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream parameter is NULL!");
        this.stream.add(outputStream);
    }

    public void addOutPutStreams(List<OutputStream> outputStreams) {
        Preconditions.checkNotNull(outputStreams, (Object)"outputStreams parameter is NULL!");
        for (OutputStream stream : outputStreams) {
            this.addOutPutStream(stream);
        }
    }

    public Optional<OutputStream> removeOutPutStream(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream parameter is NULL!");
        return this.stream.remove(outputStream);
    }

    public boolean clearOutPutStreams() {
        return this.stream.clear();
    }

    public void enableDefaultSlf4jLoggingOfOutputData() {
        this.addSlf4jLogMessageConsumer((logMessage, ctx) -> {
            if (ctx.getLevel().equals((Object)Level.DEBUG)) {
                ctx.getLogger().debug(logMessage);
            } else {
                ctx.getLogger().info(logMessage);
            }
        });
    }

    public void addSlf4jLogMessageConsumer(BiConsumer<String, Slf4jLogMessageContext> slf4jLogMessageConsumer) {
        Preconditions.checkNotNull(slf4jLogMessageConsumer, (Object)"slf4jLogMessageConsumer parameter is NULL!");
        this.addLogMessageConsumer(logMessage -> slf4jLogMessageConsumer.accept((String)logMessage, AppiumDriverLocalService.parseSlf4jContextFromLogMessage(logMessage)));
    }

    @VisibleForTesting
    static Slf4jLogMessageContext parseSlf4jContextFromLogMessage(String logMessage) {
        Matcher m = LOGGER_CONTEXT_PATTERN.matcher(logMessage);
        String loggerName = APPIUM_SERVICE_SLF4J_LOGGER_PREFIX;
        Level level = Level.INFO;
        if (m.find()) {
            loggerName = loggerName + "." + m.group(2).toLowerCase().replaceAll("\\s+", "");
            if (m.group(1) != null) {
                level = Level.DEBUG;
            }
        }
        return new Slf4jLogMessageContext(loggerName, level);
    }

    public void addLogMessageConsumer(final Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer, (Object)"consumer parameter is NULL!");
        this.addOutPutStream(new OutputStream(){
            private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

            @Override
            public void write(int chr) {
                try {
                    this.outputStream.write(chr);
                    if (chr == 10) {
                        consumer.accept(this.outputStream.toString());
                        this.outputStream.reset();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Log message consumer crashed!", (Throwable)e);
                }
            }
        });
    }
}

