/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.utils;

import io.appium.java_client.pagefactory.bys.ContentType;
import org.openqa.selenium.ContextAware;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;

public final class WebDriverUnpackUtility {
    private static final String NATIVE_APP_PATTERN = "NATIVE_APP";

    public static WebDriver unpackWebDriverFromSearchContext(SearchContext searchContext) {
        if (searchContext instanceof WebDriver) {
            return (WebDriver)searchContext;
        }
        if (searchContext instanceof WrapsDriver) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsDriver)searchContext).getWrappedDriver());
        }
        if (searchContext instanceof WrapsElement) {
            return WebDriverUnpackUtility.unpackWebDriverFromSearchContext(((WrapsElement)searchContext).getWrappedElement());
        }
        return null;
    }

    public static ContentType getCurrentContentType(SearchContext context) {
        WebDriver driver = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(context);
        if (!ContextAware.class.isAssignableFrom(driver.getClass())) {
            return ContentType.HTML_OR_DEFAULT;
        }
        ContextAware contextAware = (ContextAware)ContextAware.class.cast(driver);
        String currentContext = contextAware.getContext();
        if (currentContext.contains(NATIVE_APP_PATTERN)) {
            return ContentType.NATIVE_MOBILE_SPECIFIC;
        }
        return ContentType.HTML_OR_DEFAULT;
    }
}

