/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AppiumFieldDecorator;
import io.appium.java_client.pagefactory.ThrowableUtil;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.Widget;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.interceptors.InterceptorOfASingleElement;
import io.appium.java_client.pagefactory.locator.CacheableLocator;
import io.appium.java_client.pagefactory.utils.WebDriverUnpackUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodProxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

class WidgetInterceptor
extends InterceptorOfASingleElement {
    private final Map<ContentType, Constructor<? extends Widget>> instantiationMap;
    private final Map<ContentType, Widget> cachedInstances = new HashMap<ContentType, Widget>();
    private final TimeOutDuration duration;
    private WebElement cachedElement;

    WidgetInterceptor(CacheableLocator locator, WebDriver driver, WebElement cachedElement, Map<ContentType, Constructor<? extends Widget>> instantiationMap, TimeOutDuration duration) {
        super(locator, driver);
        this.cachedElement = cachedElement;
        this.instantiationMap = instantiationMap;
        this.duration = duration;
    }

    @Override
    protected Object getObject(WebElement element, Method method, Object[] args) throws Throwable {
        ContentType type = WebDriverUnpackUtility.getCurrentContentType(element);
        if (this.cachedElement == null || this.locator != null && !((CacheableLocator)this.locator).isLookUpCached() || this.cachedInstances.size() == 0) {
            this.cachedElement = element;
            Constructor<? extends Widget> constructor = this.instantiationMap.get((Object)type);
            Class<? extends Widget> clazz = constructor.getDeclaringClass();
            int modifiers = clazz.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                throw new InstantiationException(String.valueOf(clazz.getName()) + " is abstract so " + "it can't be instantiated");
            }
            Widget widget = constructor.newInstance(this.cachedElement);
            this.cachedInstances.put(type, widget);
            PageFactory.initElements((FieldDecorator)new AppiumFieldDecorator(widget, this.duration), (Object)widget);
        }
        try {
            method.setAccessible(true);
            return method.invoke((Object)this.cachedInstances.get((Object)type), args);
        }
        catch (Throwable t) {
            throw ThrowableUtil.extractReadableException(t);
        }
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (this.locator != null) {
            return super.intercept(obj, method, args, proxy);
        }
        return this.getObject(this.cachedElement, method, args);
    }
}

