/*
 * Decompiled with CFR 0.152.
 */
package io.appform.testcontainers.mariadb.container;

import com.github.dockerjava.api.DockerClient;
import io.appform.testcontainers.commons.ContainerUtils;
import io.appform.testcontainers.mariadb.MariaDbContainerStatusCheck;
import io.appform.testcontainers.mariadb.config.MariaDbContainerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MariaDbContainer
extends GenericContainer<MariaDbContainer> {
    private static final Logger log = LoggerFactory.getLogger(MariaDbContainer.class);
    private final MariaDbContainerConfiguration mariaDbContainerConfiguration;

    public MariaDbContainer() {
        this(new MariaDbContainerConfiguration());
    }

    public MariaDbContainer(MariaDbContainerConfiguration mariaDbContainerConfiguration) {
        super(mariaDbContainerConfiguration.getDockerImage());
        ((MariaDbContainer)((MariaDbContainer)((MariaDbContainer)((MariaDbContainer)((MariaDbContainer)((MariaDbContainer)((MariaDbContainer)this.withEnv("MYSQL_DATABASE", mariaDbContainerConfiguration.getDatabaseName())).withEnv("MYSQL_USER", mariaDbContainerConfiguration.getUserName())).withEnv("MYSQL_PASSWORD", mariaDbContainerConfiguration.getUserPassword())).withEnv("MYSQL_ROOT_PASSWORD", mariaDbContainerConfiguration.getRootPassword())).withExposedPorts(new Integer[]{3306})).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log))).waitingFor((WaitStrategy)new MariaDbContainerStatusCheck(mariaDbContainerConfiguration))).withStartupTimeout(mariaDbContainerConfiguration.getTimeoutDuration());
        this.mariaDbContainerConfiguration = mariaDbContainerConfiguration;
    }

    public int getJdbcPort() {
        return this.getMappedPort(3306);
    }

    public String getRootPassword() {
        return this.mariaDbContainerConfiguration.getRootPassword();
    }

    public boolean executeQuery(String query, boolean asRootUser) {
        ContainerUtils.ExecCmdResult execCmdResult = ContainerUtils.execCmd((DockerClient)DockerClientFactory.instance().client(), (String)this.getContainerId(), (String[])new String[]{"mysql", "--user=" + (asRootUser ? "root" : this.mariaDbContainerConfiguration.getUserName()), "--password=" + (asRootUser ? this.mariaDbContainerConfiguration.getRootPassword() : this.mariaDbContainerConfiguration.getUserPassword()), "-e", query});
        return execCmdResult.getExitCode() == 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MariaDbContainer)) {
            return false;
        }
        MariaDbContainer other = (MariaDbContainer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MariaDbContainerConfiguration this$mariaDbContainerConfiguration = this.mariaDbContainerConfiguration;
        MariaDbContainerConfiguration other$mariaDbContainerConfiguration = other.mariaDbContainerConfiguration;
        return !(this$mariaDbContainerConfiguration == null ? other$mariaDbContainerConfiguration != null : !((Object)((Object)this$mariaDbContainerConfiguration)).equals((Object)other$mariaDbContainerConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MariaDbContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        MariaDbContainerConfiguration $mariaDbContainerConfiguration = this.mariaDbContainerConfiguration;
        result = result * 59 + ($mariaDbContainerConfiguration == null ? 43 : ((Object)((Object)$mariaDbContainerConfiguration)).hashCode());
        return result;
    }
}

