/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ConversionHelper {
    private ConversionHelper() {
    }

    public static <S> S convertToSimpleType(Object value, Function<Object, S> conversionFunction) {
        try {
            return conversionFunction.apply(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <S> Map<String, S> convertToMap(Object value, Function<Object, S> conversionFunction) {
        if (value == null) {
            return null;
        }
        try {
            Map valueMap = (Map)value;
            return valueMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ConversionHelper.convertToSimpleType(entry.getValue(), conversionFunction))).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <S> List<S> convertToArray(Object value, Function<Object, S> conversionFunction) {
        if (value == null) {
            return null;
        }
        try {
            List valueList = (List)value;
            return valueList.stream().map(item -> ConversionHelper.convertToSimpleType(item, conversionFunction)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <S> List<Map<String, S>> convertToArrayOfMap(Object value, Function<Object, S> conversionFunction) {
        if (value == null) {
            return null;
        }
        try {
            List valueList = (List)value;
            return valueList.stream().map(item -> ConversionHelper.convertToMap(item, conversionFunction)).filter(map -> map != null && !map.isEmpty()).collect(Collectors.toList());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <S> Map<String, List<S>> convertToMapOfArray(Object value, Function<Object, S> conversionFunction) {
        if (value == null) {
            return null;
        }
        try {
            Map valueMap = (Map)value;
            return valueMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ConversionHelper.convertToArray(entry.getValue(), conversionFunction))).filter(entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T, S> T convertToNDimensionalArray(Object value, Function<Object, S> conversionFunction, int dimensionCount) {
        if (value == null) {
            return null;
        }
        try {
            return (T)ConversionHelper.convertToNDimensionalArrayInternal(value, conversionFunction, dimensionCount);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <S> List<?> convertToNDimensionalArrayInternal(Object value, Function<Object, S> conversionFunction, int dimensionCount) {
        if (value == null) {
            return null;
        }
        try {
            if (dimensionCount == 1) {
                return ConversionHelper.convertToArray(value, conversionFunction);
            }
            if (dimensionCount > 1) {
                List valueList = (List)value;
                return valueList.stream().map(item -> ConversionHelper.convertToNDimensionalArray(item, conversionFunction, dimensionCount - 1)).filter(item -> item != null && !((List)item).isEmpty()).collect(Collectors.toList());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

