/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import com.fasterxml.jackson.core.type.TypeReference;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.HttpRequest;
import io.apimatic.core.configurations.http.request.EndpointConfiguration;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.types.pagination.PaginationDataManager;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class PaginatedData<T, P>
implements Iterator<T> {
    private int currentIndex = 0;
    private final List<T> data = new ArrayList<T>();
    private final List<P> pages = new ArrayList<P>();
    private int lastDataSize;
    private Response lastResponse;
    private HttpRequest.Builder lastRequestBuilder;
    private final TypeReference<P> pageType;
    private final Function<P, List<T>> converter;
    private final PaginationDataManager[] dataManagers;
    private final EndpointConfiguration endpointConfig;
    private final GlobalConfiguration globalConfig;

    public PaginatedData(PaginatedData<T, P> paginatedData) {
        this.pageType = paginatedData.pageType;
        this.converter = paginatedData.converter;
        this.dataManagers = paginatedData.dataManagers;
        this.endpointConfig = paginatedData.endpointConfig;
        this.globalConfig = paginatedData.globalConfig;
        this.lastDataSize = paginatedData.lastDataSize;
        this.lastResponse = paginatedData.lastResponse;
        this.lastRequestBuilder = paginatedData.lastRequestBuilder;
        this.data.addAll(paginatedData.data);
        this.pages.addAll(paginatedData.pages);
    }

    public PaginatedData(EndpointConfiguration config, GlobalConfiguration globalConfig, HttpRequest.Builder requestBuilder, Response response, TypeReference<P> pageType, Function<P, List<T>> converter, PaginationDataManager ... dataManagers) throws IOException {
        this.pageType = pageType;
        this.converter = converter;
        this.dataManagers = dataManagers;
        this.endpointConfig = config;
        this.globalConfig = globalConfig;
        this.updateUsing(response, requestBuilder);
    }

    private void updateUsing(Response response, HttpRequest.Builder requestBuilder) throws IOException {
        String responseBody = response.getBody();
        P page = CoreHelper.deserialize(responseBody, this.pageType);
        List<T> newData = this.converter.apply(page);
        this.lastDataSize = newData.size();
        this.lastResponse = response;
        this.lastRequestBuilder = requestBuilder;
        this.data.addAll(newData);
        this.pages.add(page);
    }

    public HttpRequest.Builder getLastRequestBuilder() {
        return this.lastRequestBuilder;
    }

    public String getLastResponseBody() {
        return this.lastResponse.getBody();
    }

    public String getLastResponseHeaders() {
        return CoreHelper.trySerialize(this.lastResponse.getHeaders().asSimpleMap());
    }

    public int getLastDataSize() {
        return this.lastDataSize;
    }

    public PaginatedData<T, P> reset() {
        if (this.currentIndex == 0) {
            return this;
        }
        return new PaginatedData<T, P>(this);
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex < this.data.size()) {
            return true;
        }
        this.fetchMoreData();
        return this.currentIndex < this.data.size();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.data.get(this.currentIndex++);
        }
        throw new NoSuchElementException("No more data available.");
    }

    public Iterator<T> iterator() {
        return this.reset();
    }

    public Iterable<P> pages() {
        final PaginatedData<T, P> dataCopy = this.reset();
        return new Iterable<P>(){

            @Override
            public Iterator<P> iterator() {
                return new Iterator<P>(){
                    private int currentIndex = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.currentIndex < dataCopy.pages.size()) {
                            return true;
                        }
                        while (dataCopy.hasNext()) {
                            if (this.currentIndex < dataCopy.pages.size()) {
                                return true;
                            }
                            dataCopy.next();
                        }
                        return false;
                    }

                    @Override
                    public P next() {
                        if (dataCopy.hasNext()) {
                            return dataCopy.pages.get(this.currentIndex++);
                        }
                        throw new NoSuchElementException("No more data available.");
                    }
                };
            }
        };
    }

    private void fetchMoreData() {
        for (PaginationDataManager manager : this.dataManagers) {
            if (!manager.isValid(this)) continue;
            try {
                PaginatedData result = (PaginatedData)new ApiCall.Builder().endpointConfiguration(this.endpointConfig.toBuilder()).globalConfig(this.globalConfig).requestBuilder(manager.getNextRequestBuilder()).responseHandler(res -> res.globalErrorCase(Collections.singletonMap("DEFAULT", ErrorCase.setReason(null, CoreApiException::new))).nullify404(false).paginatedDeserializer(this.pageType, this.converter, r -> r, this.dataManagers)).build().execute();
                this.updateUsing(result.lastResponse, result.lastRequestBuilder);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

