/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.HttpRequest;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationDataManager;
import io.apimatic.core.utilities.CoreHelper;

public class LinkPagination
implements PaginationDataManager {
    private final String next;
    private HttpRequest.Builder nextReqBuilder;

    public LinkPagination(String next) {
        this.next = next;
    }

    @Override
    public boolean isValid(PaginatedData<?, ?> paginatedData) {
        this.nextReqBuilder = paginatedData.getLastRequestBuilder();
        String linkValue = CoreHelper.resolveResponsePointer(this.next, paginatedData.getLastResponseBody(), paginatedData.getLastResponseHeaders());
        if (linkValue == null) {
            return false;
        }
        this.nextReqBuilder.queryParam(CoreHelper.getQueryParameters(linkValue));
        return true;
    }

    @Override
    public HttpRequest.Builder getNextRequestBuilder() {
        return this.nextReqBuilder;
    }
}

