/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import com.fasterxml.jackson.core.type.TypeReference;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.HttpRequest;
import io.apimatic.core.configurations.http.request.EndpointConfiguration;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.types.pagination.PaginatedData;
import io.apimatic.core.types.pagination.PaginationDataManager;
import io.apimatic.core.types.pagination.PaginationDeserializer;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.Context;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import io.apimatic.coreinterfaces.http.response.Response;
import io.apimatic.coreinterfaces.type.functional.ContextInitializer;
import io.apimatic.coreinterfaces.type.functional.Deserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResponseHandler<ResponseType, ExceptionType extends CoreApiException> {
    private static final int NOT_FOUND_STATUS_CODE = 404;
    private static final int MIN_SUCCESS_CODE = 200;
    private static final int MAX_SUCCESS_CODE = 208;
    private final Map<String, ErrorCase<ExceptionType>> localErrorCases;
    private final Map<String, ErrorCase<ExceptionType>> globalErrorCases;
    private final Deserializer<?> deserializer;
    private final PaginationDeserializer paginationDeserializer;
    private final ResponseClassType responseClassType;
    private final ContextInitializer<ResponseType> contextInitializer;
    private final boolean isNullify404Enabled;
    private final boolean isNullableResponseType;

    private ResponseHandler(Map<String, ErrorCase<ExceptionType>> localErrorCases, Map<String, ErrorCase<ExceptionType>> globalErrorCases, Deserializer<ResponseType> deserializer, Deserializer<?> intermediateDeserializer, PaginationDeserializer paginationDeserializer, ResponseClassType responseClassType, ContextInitializer<ResponseType> contextInitializer, boolean isNullify404Enabled, boolean isNullableResponseType) {
        this.localErrorCases = localErrorCases;
        this.globalErrorCases = globalErrorCases;
        this.deserializer = deserializer == null ? intermediateDeserializer : deserializer;
        this.paginationDeserializer = paginationDeserializer;
        this.responseClassType = responseClassType;
        this.contextInitializer = contextInitializer;
        this.isNullify404Enabled = isNullify404Enabled;
        this.isNullableResponseType = isNullableResponseType;
    }

    public ResponseType handle(Context context, EndpointConfiguration config, GlobalConfiguration globalConfig, HttpRequest.Builder requestBuilder) throws IOException, ExceptionType {
        int responseCode;
        if (globalConfig.getHttpCallback() != null) {
            globalConfig.getHttpCallback().onAfterResponse(context);
        }
        if (this.isNullify404Enabled && (responseCode = context.getResponse().getStatusCode()) == 404) {
            return null;
        }
        this.validateResponse(context);
        Object result = this.convertResponse(context.getResponse(), requestBuilder, config, globalConfig);
        if (this.responseClassType == ResponseClassType.API_RESPONSE || this.responseClassType == ResponseClassType.DYNAMIC_API_RESPONSE) {
            return this.createApiResponse(context.getResponse(), globalConfig.getCompatibilityFactory(), result);
        }
        return this.applyContextInitializer(context, result);
    }

    private ResponseType applyContextInitializer(Context httpContext, Object result) throws IOException {
        if (this.contextInitializer != null && this.deserializer != null) {
            result = this.contextInitializer.apply(httpContext, result);
        }
        return (ResponseType)result;
    }

    private Object convertResponse(Response response, HttpRequest.Builder requestBuilder, EndpointConfiguration config, GlobalConfiguration globalConfig) throws IOException {
        if (this.responseClassType == ResponseClassType.DYNAMIC_RESPONSE || this.responseClassType == ResponseClassType.DYNAMIC_API_RESPONSE) {
            return this.createDynamicResponse(response, globalConfig.getCompatibilityFactory());
        }
        if (config.hasBinaryResponse()) {
            return response.getRawBody();
        }
        if (this.isNullableResponseType && CoreHelper.isNullOrWhiteSpace(response.getBody())) {
            return null;
        }
        if (this.deserializer != null) {
            return this.deserializer.apply(response.getBody());
        }
        if (this.paginationDeserializer != null) {
            return this.paginationDeserializer.apply(config, globalConfig, requestBuilder, response);
        }
        return null;
    }

    private Object createDynamicResponse(Response httpResponse, CompatibilityFactory compatibilityFactory) {
        return compatibilityFactory.createDynamicResponse(httpResponse);
    }

    private ResponseType createApiResponse(Response httpResponse, CompatibilityFactory compatibilityFactory, Object innerValue) {
        return (ResponseType)compatibilityFactory.createApiResponse(httpResponse.getStatusCode(), httpResponse.getHeaders(), innerValue);
    }

    private void validateResponse(Context httpContext) throws ExceptionType {
        Response response = httpContext.getResponse();
        int statusCode = response.getStatusCode();
        String errorCode = String.valueOf(statusCode);
        this.throwConfiguredException(this.localErrorCases, errorCode, httpContext);
        this.throwConfiguredException(this.globalErrorCases, errorCode, httpContext);
        if (statusCode < 200 || statusCode > 208) {
            this.globalErrorCases.get("DEFAULT").throwException(httpContext);
        }
    }

    private void throwConfiguredException(Map<String, ErrorCase<ExceptionType>> errorCases, String errorCode, Context httpContext) throws ExceptionType {
        String defaultErrorCode = "";
        Matcher match = Pattern.compile("^[(4|5)[0-9]]{3}").matcher(errorCode);
        if (match.find()) {
            defaultErrorCode = errorCode.charAt(0) + "XX";
        }
        if (errorCases != null) {
            if (errorCases.containsKey(errorCode)) {
                errorCases.get(errorCode).throwException(httpContext);
            }
            if (errorCases.containsKey(defaultErrorCode)) {
                errorCases.get(defaultErrorCode).throwException(httpContext);
            }
        }
    }

    public static class Builder<ResponseType, ExceptionType extends CoreApiException> {
        private Map<String, ErrorCase<ExceptionType>> localErrorCases = null;
        private Map<String, ErrorCase<ExceptionType>> globalErrorCases = null;
        private Deserializer<ResponseType> deserializer;
        private Deserializer<?> intermediateDeserializer;
        private PaginationDeserializer paginationDeserializer;
        private ResponseClassType responseClassType;
        private ContextInitializer<ResponseType> contextInitializer;
        private boolean isNullify404Enabled = true;
        private boolean isNullableResponseType = false;

        public Builder<ResponseType, ExceptionType> localErrorCase(String statusCode, ErrorCase<ExceptionType> errorCase) {
            if (this.localErrorCases == null) {
                this.localErrorCases = new HashMap<String, ErrorCase<ExceptionType>>();
            }
            this.localErrorCases.put(statusCode, errorCase);
            return this;
        }

        public Builder<ResponseType, ExceptionType> globalErrorCase(Map<String, ErrorCase<ExceptionType>> globalErrorCases) {
            this.globalErrorCases = globalErrorCases;
            return this;
        }

        public Builder<ResponseType, ExceptionType> deserializer(Deserializer<ResponseType> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public <IntermediateResponseType> Builder<ResponseType, ExceptionType> apiResponseDeserializer(Deserializer<IntermediateResponseType> intermediateDeserializer) {
            this.intermediateDeserializer = intermediateDeserializer;
            return this;
        }

        public <InnerType, Page> Builder<ResponseType, ExceptionType> paginatedDeserializer(TypeReference<Page> pageType, Function<Page, List<InnerType>> converter, Function<PaginatedData<InnerType, Page>, ?> returnTypeGetter, PaginationDataManager ... dataManagers) {
            this.paginationDeserializer = (config, globalConfig, reqBuilder, res) -> returnTypeGetter.apply(new PaginatedData(config, globalConfig, reqBuilder, res, pageType, converter, dataManagers));
            return this;
        }

        public Builder<ResponseType, ExceptionType> responseClassType(ResponseClassType responseClassType) {
            this.responseClassType = responseClassType;
            return this;
        }

        public Builder<ResponseType, ExceptionType> contextInitializer(ContextInitializer<ResponseType> contextInitializer) {
            this.contextInitializer = contextInitializer;
            return this;
        }

        public Builder<ResponseType, ExceptionType> nullify404(boolean isNullify404Enabled) {
            this.isNullify404Enabled = isNullify404Enabled;
            return this;
        }

        public Builder<ResponseType, ExceptionType> nullableResponseType(boolean isNullableResponseType) {
            this.isNullableResponseType = isNullableResponseType;
            return this;
        }

        public ResponseHandler<ResponseType, ExceptionType> build() {
            return new ResponseHandler(this.localErrorCases, this.globalErrorCases, this.deserializer, this.intermediateDeserializer, this.paginationDeserializer, this.responseClassType, this.contextInitializer, this.isNullify404Enabled, this.isNullableResponseType);
        }
    }
}

