/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.Parameter;
import io.apimatic.core.authentication.AuthBuilder;
import io.apimatic.core.exceptions.AuthValidationException;
import io.apimatic.core.types.http.request.MultipartFileWrapper;
import io.apimatic.core.types.http.request.MultipartWrapper;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.authentication.Authentication;
import io.apimatic.coreinterfaces.compatibility.CompatibilityFactory;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ArraySerializationFormat;
import io.apimatic.coreinterfaces.http.request.MutliPartRequestType;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.type.CoreFileWrapper;
import io.apimatic.coreinterfaces.type.functional.Serializer;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public final class HttpRequest {
    private final Request coreHttpRequest;
    private final GlobalConfiguration coreConfig;
    private final StringBuilder queryUrlBuilder;
    private final CompatibilityFactory compatibilityFactory;

    private HttpRequest(GlobalConfiguration coreConfig, String server, String path, Method httpMethod, Authentication authentication, Map<String, Object> queryParams, Map<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParams, Map<String, List<String>> headerParams, Set<Parameter> formParams, Map<String, Object> formParameters, Object body, Serializer bodySerializer, Map<String, Object> bodyParameters, ArraySerializationFormat arraySerializationFormat) throws IOException {
        this.coreConfig = coreConfig;
        this.compatibilityFactory = coreConfig.getCompatibilityFactory();
        HttpHeaders requestHeaders = this.addHeaders(headerParams);
        Request request = this.buildBasicRequest(httpMethod, requestHeaders);
        if (request != null) {
            this.applyAuthentication(request, authentication);
            if (request.getQueryParameters() != null) {
                queryParams.putAll(request.getQueryParameters());
            }
        }
        this.queryUrlBuilder = this.getStringBuilder(server, path, queryParams, arraySerializationFormat);
        this.processTemplateParams(templateParams);
        Object bodyValue = this.buildBody(body, bodySerializer, bodyParameters);
        List<AbstractMap.SimpleEntry<String, Object>> formFields = this.generateFormFields(formParams, formParameters, arraySerializationFormat);
        this.coreHttpRequest = this.buildRequest(httpMethod, bodyValue, requestHeaders, queryParams, formFields, arraySerializationFormat);
    }

    public Request getCoreHttpRequest() {
        return this.coreHttpRequest;
    }

    private Request buildRequest(Method httpMethod, Object body, HttpHeaders headerParams, Map<String, Object> queryParams, List<AbstractMap.SimpleEntry<String, Object>> formFields, ArraySerializationFormat arraySerializationFormat) throws IOException {
        if (body != null) {
            return this.compatibilityFactory.createHttpRequest(httpMethod, this.queryUrlBuilder, headerParams, queryParams, body);
        }
        return this.compatibilityFactory.createHttpRequest(httpMethod, this.queryUrlBuilder, headerParams, queryParams, formFields);
    }

    private Request buildBasicRequest(Method httpMethod, HttpHeaders headerParams) throws IOException {
        return this.compatibilityFactory.createHttpRequest(httpMethod, null, headerParams, new HashMap(), Collections.emptyList());
    }

    private void applyAuthentication(Request request, Authentication authentication) {
        if (authentication != null) {
            authentication.validate();
            if (!authentication.isValid()) {
                throw new AuthValidationException(authentication.getErrorMessage());
            }
            authentication.apply(request);
        }
    }

    private List<AbstractMap.SimpleEntry<String, Object>> generateFormFields(Set<Parameter> formParams, Map<String, Object> optionalFormParamaters, ArraySerializationFormat arraySerializationFormat) throws IOException {
        if (formParams.isEmpty() && optionalFormParamaters.isEmpty()) {
            return null;
        }
        HashMap<String, Object> formParameters = new HashMap<String, Object>();
        for (Parameter formParameter : formParams) {
            String key = formParameter.getKey();
            Object value = formParameter.getValue();
            if (formParameter.getMultiPartRequest() != null) {
                value = this.handleMultiPartRequest(formParameter);
            }
            formParameters.put(key, value);
        }
        formParameters.putAll(optionalFormParamaters);
        return CoreHelper.prepareFormFields(formParameters, arraySerializationFormat);
    }

    private StringBuilder getStringBuilder(String server, String path, Map<String, Object> queryParams, ArraySerializationFormat arraySerializationFormat) {
        StringBuilder urlBuilder = new StringBuilder(this.coreConfig.getBaseUri().apply(server) + path);
        CoreHelper.appendUrlWithQueryParameters(urlBuilder, queryParams, arraySerializationFormat);
        return new StringBuilder(CoreHelper.cleanUrl(urlBuilder));
    }

    private void processTemplateParams(Map<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParams) {
        if (!templateParams.isEmpty()) {
            CoreHelper.appendUrlWithTemplateParameters(this.queryUrlBuilder, templateParams);
        }
    }

    private HttpHeaders addHeaders(Map<String, List<String>> headerParams) {
        this.addGlobalHeader(headerParams);
        this.addAdditionalHeaders(headerParams);
        return this.compatibilityFactory.createHttpHeaders(headerParams);
    }

    private void addGlobalHeader(Map<String, List<String>> headerParams) {
        this.coreConfig.getGlobalHeaders().forEach((key, value) -> {
            if (!headerParams.containsKey(key)) {
                headerParams.put((String)key, (List<String>)value);
            }
        });
    }

    private void addAdditionalHeaders(Map<String, List<String>> headerParams) {
        if (this.coreConfig.getAdditionalHeaders() != null) {
            headerParams.putAll(this.coreConfig.getAdditionalHeaders().asMultimap());
        }
    }

    private Object buildBody(Object body, Serializer bodySerializer, Map<String, Object> bodyParameters) throws IOException {
        if (body != null) {
            if (bodySerializer != null) {
                return bodySerializer.supply();
            }
            if (body instanceof CoreFileWrapper) {
                return body;
            }
            if (body instanceof String) {
                return body.toString();
            }
            return CoreHelper.serialize(body);
        }
        if (bodyParameters != null) {
            CoreHelper.removeNullValues(bodyParameters);
            return CoreHelper.serialize(bodyParameters);
        }
        return body;
    }

    private Object handleMultiPartRequest(Parameter formParameter) throws IOException {
        HttpHeaders multipartFileHeaders = this.compatibilityFactory.createHttpHeaders(formParameter.getMultipartHeaders());
        if (formParameter.getMultiPartRequest() == MutliPartRequestType.MULTI_PART_FILE) {
            return new MultipartFileWrapper((CoreFileWrapper)formParameter.getValue(), multipartFileHeaders);
        }
        String value = formParameter.getMultipartSerializer().supply();
        return new MultipartWrapper(value, multipartFileHeaders);
    }

    public static class Builder {
        private String server;
        private String path;
        private Method httpMethod;
        private AuthBuilder authBuilder = new AuthBuilder();
        private Map<String, Object> queryParams = new HashMap<String, Object>();
        private Map<String, AbstractMap.SimpleEntry<Object, Boolean>> templateParams = new HashMap<String, AbstractMap.SimpleEntry<Object, Boolean>>();
        private Map<String, List<Object>> headerParams = new HashMap<String, List<Object>>();
        private Set<Parameter> formParams = new HashSet<Parameter>();
        private Map<String, Object> formParamaters = new HashMap<String, Object>();
        private Object body;
        private Serializer bodySerializer;
        private Map<String, Object> bodyParameters;
        private ArraySerializationFormat arraySerializationFormat = ArraySerializationFormat.INDEXED;
        private Parameter.Builder parameterBuilder = new Parameter.Builder();

        public Builder updateByReference(String pointer, UnaryOperator<Object> setter) {
            if (pointer == null) {
                return this;
            }
            String[] pointerParts = pointer.split("#");
            String prefix = pointerParts[0];
            String point = pointerParts.length > 1 ? pointerParts[1] : "";
            switch (prefix) {
                case "$request.path": {
                    this.updateTemplateParams(setter, point);
                    return this;
                }
                case "$request.query": {
                    this.queryParams = CoreHelper.updateValueByPointer(this.queryParams, point, setter);
                    return this;
                }
                case "$request.headers": {
                    this.updateHeaderParams(setter, point);
                    return this;
                }
            }
            return this;
        }

        private void updateHeaderParams(UnaryOperator<Object> setter, String point) {
            Map<String, Object> simplifiedHeaders = new HashMap();
            for (Map.Entry<String, List<Object>> entry : this.headerParams.entrySet()) {
                if (entry.getValue().size() == 1) {
                    simplifiedHeaders.put(entry.getKey(), entry.getValue().get(0));
                    continue;
                }
                simplifiedHeaders.put(entry.getKey(), entry.getValue());
            }
            simplifiedHeaders = CoreHelper.updateValueByPointer(simplifiedHeaders, point, setter);
            for (Map.Entry<String, List<Object>> entry : simplifiedHeaders.entrySet()) {
                if (entry.getValue() instanceof List) {
                    this.headerParams.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.headerParams.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
        }

        private void updateTemplateParams(UnaryOperator<Object> setter, String point) {
            Map simplifiedPath = new HashMap<String, Object>();
            for (Map.Entry<String, AbstractMap.SimpleEntry<Object, Boolean>> entry : this.templateParams.entrySet()) {
                simplifiedPath.put(entry.getKey(), entry.getValue().getKey());
            }
            simplifiedPath = CoreHelper.updateValueByPointer(simplifiedPath, point, setter);
            for (Map.Entry<String, AbstractMap.SimpleEntry<Object, Boolean>> entry : simplifiedPath.entrySet()) {
                Boolean originalFlag = this.templateParams.containsKey(entry.getKey()) ? this.templateParams.get(entry.getKey()).getValue() : Boolean.valueOf(false);
                this.templateParams.put(entry.getKey(), new AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<Object, Boolean>, Boolean>(entry.getValue(), originalFlag));
            }
        }

        public Builder server(String server) {
            this.server = server;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder httpMethod(Method httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder withAuth(Consumer<AuthBuilder> consumer) {
            consumer.accept(this.authBuilder);
            return this;
        }

        public Builder queryParam(Map<String, Object> queryParameters) {
            this.queryParams.putAll(queryParameters);
            return this;
        }

        public Builder queryParam(Consumer<Parameter.Builder> action) {
            action.accept(this.parameterBuilder);
            Parameter queryParameter = this.parameterBuilder.build();
            queryParameter.validate();
            this.queryParams.put(queryParameter.getKey(), queryParameter.getValue());
            return this;
        }

        public Builder templateParam(Consumer<Parameter.Builder> action) {
            this.parameterBuilder = new Parameter.Builder();
            action.accept(this.parameterBuilder);
            Parameter templateParameter = this.parameterBuilder.build();
            templateParameter.validate();
            AbstractMap.SimpleEntry<Object, Boolean> templateEntry = new AbstractMap.SimpleEntry<Object, Boolean>(templateParameter.getValue(), templateParameter.shouldEncode());
            this.templateParams.put(templateParameter.getKey(), templateEntry);
            return this;
        }

        public Builder headerParam(Consumer<Parameter.Builder> action) {
            this.parameterBuilder = new Parameter.Builder();
            action.accept(this.parameterBuilder);
            Parameter httpHeaderParameter = this.parameterBuilder.build();
            httpHeaderParameter.validate();
            String key = httpHeaderParameter.getKey();
            if (this.headerParams.containsKey(key)) {
                this.headerParams.get(key).add(httpHeaderParameter.getValue());
            } else {
                ArrayList<Object> headerValues = new ArrayList<Object>();
                headerValues.add(httpHeaderParameter.getValue());
                this.headerParams.put(key, headerValues);
            }
            return this;
        }

        public Builder formParam(Consumer<Parameter.Builder> action) {
            this.parameterBuilder = new Parameter.Builder();
            action.accept(this.parameterBuilder);
            Parameter formParameter = this.parameterBuilder.build();
            formParameter.validate();
            this.formParams.add(formParameter);
            return this;
        }

        public Builder formParam(Map<String, Object> formParameters) {
            this.formParamaters.putAll(formParameters);
            return this;
        }

        public Builder bodyParam(Consumer<Parameter.Builder> action) {
            this.parameterBuilder = new Parameter.Builder();
            action.accept(this.parameterBuilder);
            Parameter bodyParam = this.parameterBuilder.build();
            bodyParam.validate();
            if (bodyParam.getKey() != null && !bodyParam.getKey().isEmpty()) {
                if (this.bodyParameters == null) {
                    this.bodyParameters = new HashMap<String, Object>();
                }
                this.bodyParameters.put(bodyParam.getKey(), bodyParam.getValue());
            } else {
                this.body = bodyParam.getValue();
            }
            return this;
        }

        public Builder bodySerializer(Serializer bodySerializer) {
            this.bodySerializer = bodySerializer;
            return this;
        }

        public Builder arraySerializationFormat(ArraySerializationFormat arraySerializationFormat) {
            this.arraySerializationFormat = arraySerializationFormat;
            return this;
        }

        private Map<String, List<String>> getHeaderParams() {
            HashMap<String, List<String>> converted = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<Object>> entry : this.headerParams.entrySet()) {
                String key = entry.getKey();
                List<Object> originalList = entry.getValue();
                ArrayList<String> serializedList = new ArrayList<String>();
                for (Object obj : originalList) {
                    serializedList.add(Builder.getSerializedHeaderValue(obj));
                }
                converted.put(key, serializedList);
            }
            return converted;
        }

        private static String getSerializedHeaderValue(Object obj) {
            if (obj == null) {
                return null;
            }
            if (CoreHelper.isTypeCombinatorStringCase(obj) || CoreHelper.isTypeCombinatorDateTimeCase(obj) || obj instanceof String) {
                return obj.toString();
            }
            return CoreHelper.trySerialize(obj);
        }

        public Request build(GlobalConfiguration coreConfig) throws IOException {
            Authentication authentication = this.authBuilder.build(coreConfig.getAuthentications());
            HttpRequest coreRequest = new HttpRequest(coreConfig, this.server, this.path, this.httpMethod, authentication, this.queryParams, this.templateParams, this.getHeaderParams(), this.formParams, this.formParamaters, this.body, this.bodySerializer, this.bodyParameters, this.arraySerializationFormat);
            Request coreHttpRequest = coreRequest.getCoreHttpRequest();
            if (coreConfig.getHttpCallback() != null) {
                coreConfig.getHttpCallback().onBeforeRequest(coreHttpRequest);
            }
            return coreHttpRequest;
        }
    }
}

