/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import io.apimatic.core.utilities.XMLDateHelper;
import io.apimatic.core.utilities.ZonedDateTimeHelper;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlZonedDateTimeHelper
extends XMLDateHelper {
    public static String serializeRfc8601DateTime(ZonedDateTime dateObj, String rootName) {
        String xmlBlock = "<" + rootName + ">";
        xmlBlock = xmlBlock + ZonedDateTimeHelper.toRfc8601DateTime(dateObj);
        xmlBlock = xmlBlock + "</" + rootName + ">";
        return xmlBlock;
    }

    public static ZonedDateTime deserializeRfc8601DateTime(String xml) {
        Pattern pattern = Pattern.compile("<.+?>(.+?)</.+?>");
        Matcher patternMatcher = pattern.matcher(xml);
        if (!patternMatcher.find()) {
            throw new IllegalArgumentException("Invalid XML");
        }
        return ZonedDateTimeHelper.fromRfc8601DateTime(patternMatcher.group(1));
    }

    public static String serializeRfc1123DateTime(ZonedDateTime dateObj, String rootName) {
        String xmlBlock = "<" + rootName + ">";
        xmlBlock = xmlBlock + ZonedDateTimeHelper.toRfc1123DateTime(dateObj);
        xmlBlock = xmlBlock + "</" + rootName + ">";
        return xmlBlock;
    }

    public static ZonedDateTime deserializeRfc1123DateTime(String xml) {
        Pattern pattern = Pattern.compile("<.+?>(.+?)</.+?>");
        Matcher patternMatcher = pattern.matcher(xml);
        if (!patternMatcher.find()) {
            throw new IllegalArgumentException("Invalid XML");
        }
        return ZonedDateTimeHelper.fromRfc1123DateTime(patternMatcher.group(1));
    }

    public static String serializeUnixTimeStamp(ZonedDateTime dateObj, String rootName) {
        String xmlBlock = "<" + rootName + ">";
        xmlBlock = xmlBlock + ZonedDateTimeHelper.toUnixTimestamp(dateObj);
        xmlBlock = xmlBlock + "</" + rootName + ">";
        return xmlBlock;
    }

    public static ZonedDateTime deserializeUnixTimeStamp(String xml) {
        Pattern pattern = Pattern.compile("<.+?>(.+?)</.+?>");
        Matcher patternMatcher = pattern.matcher(xml);
        if (!patternMatcher.find()) {
            throw new IllegalArgumentException("Invalid XML");
        }
        return ZonedDateTimeHelper.fromUnixTimestamp(patternMatcher.group(1));
    }
}

