/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.types.pagination;

import io.apimatic.core.types.pagination.CursorPagination;
import io.apimatic.core.types.pagination.LinkPagination;
import io.apimatic.core.types.pagination.OffsetPagination;
import io.apimatic.core.types.pagination.PagePagination;
import io.apimatic.core.types.pagination.PaginationStrategy;
import io.apimatic.coreinterfaces.http.HttpHeaders;
import io.apimatic.coreinterfaces.http.response.ApiResponseType;
import io.apimatic.coreinterfaces.http.response.Response;
import java.util.List;

public final class PageWrapper<I, P>
implements ApiResponseType<P> {
    private final int statusCode;
    private final HttpHeaders headers;
    private final P page;
    private final List<I> items;
    private final PaginationStrategy strategy;
    private String nextLinkInput;
    private int offsetInput;
    private int pageInput;
    private String cursorInput;

    public static <I, P> PageWrapper<I, P> create(Response response, P page, List<I> items, PaginationStrategy strategy) {
        return new PageWrapper<I, P>(response.getStatusCode(), response.getHeaders(), page, items, strategy);
    }

    private PageWrapper(int statusCode, HttpHeaders headers, P page, List<I> items, PaginationStrategy strategy) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.page = page;
        this.items = items;
        this.strategy = strategy;
        strategy.addMetaData(this);
    }

    public boolean isCursorPagination() {
        return this.strategy instanceof CursorPagination;
    }

    public boolean isLinkPagination() {
        return this.strategy instanceof LinkPagination;
    }

    public boolean isOffsetPagination() {
        return this.strategy instanceof OffsetPagination;
    }

    public boolean isNumberPagination() {
        return this.strategy instanceof PagePagination;
    }

    public void setNextLinkInput(String nextLinkInput) {
        this.nextLinkInput = nextLinkInput;
    }

    public String getNextLinkInput() {
        return this.nextLinkInput;
    }

    public void setCursorInput(String cursorInput) {
        this.cursorInput = cursorInput;
    }

    public String getCursorInput() {
        return this.cursorInput;
    }

    public void setOffsetInput(int offsetInput) {
        this.offsetInput = offsetInput;
    }

    public int getOffsetInput() {
        return this.offsetInput;
    }

    public void setPageInput(int pageInput) {
        this.pageInput = pageInput;
    }

    public int getPageInput() {
        return this.pageInput;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public P getResult() {
        return this.page;
    }

    public List<I> getItems() {
        return this.items;
    }
}

