/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.security;

import io.apimatic.core.security.DigestCodec;
import io.apimatic.coreinterfaces.http.request.Request;
import io.apimatic.coreinterfaces.security.SignatureVerifier;
import io.apimatic.coreinterfaces.security.VerificationResult;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSignatureVerifier
implements SignatureVerifier {
    private static final String SIGNATURE_VALUE_PLACEHOLDER = "{digest}";
    private final String signatureHeaderName;
    private final String algorithm;
    private final SecretKeySpec keySpec;
    private final String signatureValueTemplate;
    private final Function<Request, byte[]> requestBytesResolver;
    private final DigestCodec digestCodec;

    public HmacSignatureVerifier(String secretKey, String signatureHeaderName, DigestCodec digestCodec, Function<Request, byte[]> requestBytesResolver, String algorithm, String signatureValueTemplate) {
        if (secretKey == null || secretKey.trim().isEmpty()) {
            throw new IllegalArgumentException("Secret key cannot be null or Empty.");
        }
        if (signatureHeaderName == null || signatureHeaderName.trim().isEmpty()) {
            throw new IllegalArgumentException("Signature header cannot be null or Empty.");
        }
        if (signatureValueTemplate == null || signatureValueTemplate.trim().isEmpty()) {
            throw new IllegalArgumentException("Signature value template cannot be null or Empty.");
        }
        if (requestBytesResolver == null) {
            throw new IllegalArgumentException("Request signature template resolver function cannot be null.");
        }
        if (digestCodec == null) {
            throw new IllegalArgumentException("Digest encoding cannot be null.");
        }
        if (algorithm == null || algorithm.trim().isEmpty()) {
            throw new IllegalArgumentException("Algorithm cannot be null or Empty.");
        }
        this.signatureHeaderName = signatureHeaderName;
        this.algorithm = algorithm;
        this.keySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), algorithm);
        this.signatureValueTemplate = signatureValueTemplate;
        this.requestBytesResolver = requestBytesResolver;
        this.digestCodec = digestCodec;
    }

    public CompletableFuture<VerificationResult> verifyAsync(Request request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String headerValue = request.getHeaders().asSimpleMap().entrySet().stream().filter(e -> e.getKey() != null && ((String)e.getKey()).equalsIgnoreCase(this.signatureHeaderName)).map(Map.Entry::getValue).findFirst().orElse(null);
                if (headerValue == null) {
                    return VerificationResult.failure((String[])new String[]{"Signature header '" + this.signatureHeaderName + "' is missing."});
                }
                byte[] provided = this.extractSignature(headerValue);
                if (provided == null || provided.length == 0) {
                    return VerificationResult.failure((String[])new String[]{"Malformed signature header '" + this.signatureHeaderName + "'."});
                }
                byte[] message = this.requestBytesResolver.apply(request);
                Mac mac = Mac.getInstance(this.algorithm);
                mac.init(this.keySpec);
                byte[] computed = mac.doFinal(message);
                return MessageDigest.isEqual(provided, computed) ? VerificationResult.success() : VerificationResult.failure((String[])new String[]{"Signature verification failed."});
            }
            catch (Exception ex) {
                return VerificationResult.failure((String[])new String[]{"Exception: " + ex.getMessage()});
            }
        });
    }

    private byte[] extractSignature(String headerValue) {
        try {
            byte[] decoded;
            int digestEnd;
            int index = this.signatureValueTemplate.indexOf(SIGNATURE_VALUE_PLACEHOLDER);
            if (index < 0) {
                return new byte[0];
            }
            String prefix = this.signatureValueTemplate.substring(0, index);
            String suffix = this.signatureValueTemplate.substring(index + SIGNATURE_VALUE_PLACEHOLDER.length());
            int prefixAt = HmacSignatureVerifier.indexOfIgnoreCase(headerValue, prefix, 0);
            if (prefixAt < 0) {
                return new byte[0];
            }
            int digestStart = prefixAt + prefix.length();
            if (suffix.isEmpty()) {
                digestEnd = headerValue.length();
            } else {
                digestEnd = HmacSignatureVerifier.indexOfIgnoreCase(headerValue, suffix, digestStart);
                if (digestEnd < 0) {
                    return new byte[0];
                }
            }
            if (digestEnd < digestStart) {
                return new byte[0];
            }
            String digest = headerValue.substring(digestStart, digestEnd).trim();
            if (digest.length() >= 2 && digest.charAt(0) == '\"' && digest.charAt(digest.length() - 1) == '\"') {
                digest = digest.substring(1, digest.length() - 1);
            }
            return (decoded = this.digestCodec.decode(digest)) == null || decoded.length == 0 ? null : decoded;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    private static int indexOfIgnoreCase(String haystack, String needle, int fromIndex) {
        if (needle.isEmpty()) {
            return fromIndex;
        }
        int max = haystack.length() - needle.length();
        for (int i = Math.max(0, fromIndex); i <= max; ++i) {
            if (!haystack.regionMatches(true, i, needle, 0, needle.length())) continue;
            return i;
        }
        return -1;
    }
}

