/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.security;

import io.apimatic.core.security.DigestCodec;
import java.util.Base64;

public final class DigestCodecFactory {
    private static final int HEX_RADIX = 16;
    private static final int HEX_BYTE_MASK = 255;
    private static final int HEX_BYTE_LENGTH = 2;
    private static final int HEX_SHIFT = 4;

    private DigestCodecFactory() {
    }

    public static DigestCodec hex() {
        return new HexDigestCodec();
    }

    public static DigestCodec base64() {
        return new Base64DigestCodec();
    }

    public static DigestCodec base64Url() {
        return new Base64UrlDigestCodec();
    }

    private static class Base64UrlDigestCodec
    implements DigestCodec {
        private Base64UrlDigestCodec() {
        }

        @Override
        public String encode(byte[] bytes) {
            return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        }

        @Override
        public byte[] decode(String encoded) {
            return Base64.getUrlDecoder().decode(encoded);
        }
    }

    private static class Base64DigestCodec
    implements DigestCodec {
        private Base64DigestCodec() {
        }

        @Override
        public String encode(byte[] bytes) {
            return Base64.getEncoder().encodeToString(bytes);
        }

        @Override
        public byte[] decode(String encoded) {
            return Base64.getDecoder().decode(encoded);
        }
    }

    private static class HexDigestCodec
    implements DigestCodec {
        private HexDigestCodec() {
        }

        @Override
        public String encode(byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }

        @Override
        public byte[] decode(String encoded) {
            int len = encoded.length();
            if (len % 2 != 0) {
                throw new IllegalArgumentException("Invalid hex string length.");
            }
            byte[] result = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                result[i / 2] = (byte)((Character.digit(encoded.charAt(i), 16) << 4) + Character.digit(encoded.charAt(i + 1), 16));
            }
            return result;
        }
    }
}

