/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.configurations.http.client;

import io.apimatic.coreinterfaces.http.ClientConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.proxy.ProxyConfiguration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import okhttp3.OkHttpClient;

public final class CoreHttpClientConfiguration
implements ClientConfiguration {
    private static final int REQUEST_TIMEOUT = 408;
    private static final int LONG_DATA = 413;
    private static final int TOO_MANY_REQUEST = 429;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final int GATEWAY_TIMEOUT = 504;
    private static final int WEB_SERVER_IS_DOWN = 521;
    private static final int CONNECTION_TIMEOUT = 522;
    private static final int SERVER_TIMEOUT = 524;
    private static final int MAX_WAIT_TIME = 120;
    private final long timeout;
    private final int numberOfRetries;
    private final int backOffFactor;
    private final long retryInterval;
    private final Set<Integer> httpStatusCodesToRetry;
    private final Set<Method> httpMethodsToRetry;
    private final long maximumRetryWaitTime;
    private final boolean shouldRetryOnTimeout;
    private final OkHttpClient httpClientInstance;
    private final boolean overrideHttpClientConfigurations;
    private final boolean skipSslCertVerification;
    private final ProxyConfiguration proxyConfiguration;

    private CoreHttpClientConfiguration(long timeout, int numberOfRetries, int backOffFactor, long retryInterval, boolean skipSslCertVerification, Set<Integer> httpStatusCodesToRetry, Set<Method> httpMethodsToRetry, long maximumRetryWaitTime, boolean shouldRetryOnTimeout, OkHttpClient httpClientInstance, boolean overrideHttpClientConfigurations, ProxyConfiguration proxyConfiguration) {
        this.timeout = timeout;
        this.numberOfRetries = numberOfRetries;
        this.backOffFactor = backOffFactor;
        this.retryInterval = retryInterval;
        this.httpStatusCodesToRetry = httpStatusCodesToRetry;
        this.httpMethodsToRetry = httpMethodsToRetry;
        this.maximumRetryWaitTime = maximumRetryWaitTime;
        this.shouldRetryOnTimeout = shouldRetryOnTimeout;
        this.httpClientInstance = httpClientInstance;
        this.overrideHttpClientConfigurations = overrideHttpClientConfigurations;
        this.skipSslCertVerification = skipSslCertVerification;
        this.proxyConfiguration = proxyConfiguration;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public int getBackOffFactor() {
        return this.backOffFactor;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public Set<Integer> getHttpStatusCodesToRetry() {
        return this.httpStatusCodesToRetry;
    }

    public Set<Method> getHttpMethodsToRetry() {
        return this.httpMethodsToRetry;
    }

    public long getMaximumRetryWaitTime() {
        return this.maximumRetryWaitTime;
    }

    public boolean shouldRetryOnTimeout() {
        return this.shouldRetryOnTimeout;
    }

    public OkHttpClient getHttpClientInstance() {
        return this.httpClientInstance;
    }

    public boolean shouldOverrideHttpClientConfigurations() {
        return this.overrideHttpClientConfigurations;
    }

    public boolean skipSslCertVerification() {
        return this.skipSslCertVerification;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public String toString() {
        return "HttpClientConfiguration [timeout=" + this.timeout + ", numberOfRetries=" + this.numberOfRetries + ", backOffFactor=" + this.backOffFactor + ", retryInterval=" + this.retryInterval + ", httpStatusCodesToRetry=" + this.httpStatusCodesToRetry + ", httpMethodsToRetry=" + this.httpMethodsToRetry + ", maximumRetryWaitTime=" + this.maximumRetryWaitTime + ", shouldRetryOnTimeout=" + this.shouldRetryOnTimeout + ", httpClientInstance=" + this.httpClientInstance + ", overrideHttpClientConfigurations=" + this.overrideHttpClientConfigurations + ", proxyConfiguration=" + this.proxyConfiguration + "]";
    }

    public Builder newBuilder() {
        return new Builder().timeout(this.timeout).numberOfRetries(this.numberOfRetries).backOffFactor(this.backOffFactor).retryInterval(this.retryInterval).httpStatusCodesToRetry(this.httpStatusCodesToRetry).httpMethodsToRetry(this.httpMethodsToRetry).maximumRetryWaitTime(this.maximumRetryWaitTime).shouldRetryOnTimeout(this.shouldRetryOnTimeout).httpClientInstance(this.httpClientInstance, this.overrideHttpClientConfigurations).proxyConfiguration(this.proxyConfiguration);
    }

    public static class Builder {
        private long timeout = 0L;
        private int numberOfRetries = 0;
        private int backOffFactor = 2;
        private long retryInterval = 1L;
        private Set<Integer> httpStatusCodesToRetry = new HashSet<Integer>();
        private Set<Method> httpMethodsToRetry = new HashSet<Method>();
        private long maximumRetryWaitTime = 120L;
        private boolean shouldRetryOnTimeout = true;
        private OkHttpClient httpClientInstance;
        private boolean overrideHttpClientConfigurations = true;
        private boolean skipSslCertVerification;
        private ProxyConfiguration proxyConfiguration;

        public Builder() {
            this.httpStatusCodesToRetry.addAll(Arrays.asList(408, 413, 429, 500, 502, 503, 504, 521, 522, 524));
            this.httpMethodsToRetry.addAll(Arrays.asList(Method.GET, Method.PUT));
        }

        public Builder timeout(long timeout) {
            if (timeout > 0L) {
                this.timeout = timeout;
            }
            return this;
        }

        public Builder numberOfRetries(int numberOfRetries) {
            if (numberOfRetries >= 0) {
                this.numberOfRetries = numberOfRetries;
            }
            return this;
        }

        public Builder backOffFactor(int backOffFactor) {
            if (backOffFactor >= 1) {
                this.backOffFactor = backOffFactor;
            }
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            if (retryInterval >= 0L) {
                this.retryInterval = retryInterval;
            }
            return this;
        }

        public Builder httpStatusCodesToRetry(Set<Integer> httpStatusCodesToRetry) {
            this.httpStatusCodesToRetry.clear();
            if (httpStatusCodesToRetry != null) {
                this.httpStatusCodesToRetry.addAll(httpStatusCodesToRetry);
            }
            return this;
        }

        public Builder httpMethodsToRetry(Set<Method> httpMethodsToRetry) {
            this.httpMethodsToRetry.clear();
            if (httpMethodsToRetry != null) {
                this.httpMethodsToRetry.addAll(httpMethodsToRetry);
            }
            return this;
        }

        public Builder maximumRetryWaitTime(long maximumRetryWaitTime) {
            if (maximumRetryWaitTime > 0L) {
                this.maximumRetryWaitTime = maximumRetryWaitTime;
            }
            return this;
        }

        public Builder shouldRetryOnTimeout(boolean shouldRetryOnTimeout) {
            this.shouldRetryOnTimeout = shouldRetryOnTimeout;
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance) {
            this.httpClientInstance = httpClientInstance;
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance, boolean overrideHttpClientConfigurations) {
            this.httpClientInstance = httpClientInstance;
            this.overrideHttpClientConfigurations = overrideHttpClientConfigurations;
            return this;
        }

        public Builder skipSslCertVerification(boolean skipSslCertVerification) {
            this.skipSslCertVerification = skipSslCertVerification;
            return this;
        }

        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public CoreHttpClientConfiguration build() {
            return new CoreHttpClientConfiguration(this.timeout, this.numberOfRetries, this.backOffFactor, this.retryInterval, this.skipSslCertVerification, this.httpStatusCodesToRetry, this.httpMethodsToRetry, this.maximumRetryWaitTime, this.shouldRetryOnTimeout, this.httpClientInstance, this.overrideHttpClientConfigurations, this.proxyConfiguration);
        }
    }
}

