/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.logger.configurations;

import io.apimatic.core.logger.ConsoleLogger;
import io.apimatic.core.logger.Slf4jLogger;
import io.apimatic.core.logger.configurations.SdkRequestLoggingConfiguration;
import io.apimatic.core.logger.configurations.SdkResponseLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.LoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.RequestLoggingConfiguration;
import io.apimatic.coreinterfaces.logger.configuration.ResponseLoggingConfiguration;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public final class SdkLoggingConfiguration
implements LoggingConfiguration {
    private final io.apimatic.coreinterfaces.logger.Logger logger;
    private final Level level;
    private final boolean maskSensitiveHeaders;
    private final RequestLoggingConfiguration requestLoggingConfiguration;
    private final ResponseLoggingConfiguration responseLoggingConfiguration;

    private SdkLoggingConfiguration(io.apimatic.coreinterfaces.logger.Logger logger, Level level, boolean maskSensitiveHeaders, RequestLoggingConfiguration requestLoggingConfiguration, ResponseLoggingConfiguration responseLoggingConfiguration) {
        this.logger = logger;
        this.level = level;
        this.maskSensitiveHeaders = maskSensitiveHeaders;
        this.requestLoggingConfiguration = requestLoggingConfiguration;
        this.responseLoggingConfiguration = responseLoggingConfiguration;
    }

    public io.apimatic.coreinterfaces.logger.Logger getLogger() {
        return this.logger;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean getMaskSensitiveHeaders() {
        return this.maskSensitiveHeaders;
    }

    public RequestLoggingConfiguration getRequestConfig() {
        return this.requestLoggingConfiguration;
    }

    public ResponseLoggingConfiguration getResponseConfig() {
        return this.responseLoggingConfiguration;
    }

    public String toString() {
        return "LoggingConfiguration [logger=" + this.getLogger() + " level=" + this.getLevel() + " maskSensitiveHeaders=" + this.getMaskSensitiveHeaders() + " requestLoggingConfiguration=" + this.getRequestConfig() + " responseLoggingConfiguration=" + this.getResponseConfig() + "]";
    }

    public Builder newBuilder() {
        Builder builder = new Builder().logger(this.logger).level(this.level).maskSensitiveHeaders(this.maskSensitiveHeaders);
        builder.requestLoggingConfigurationBuilder = ((SdkRequestLoggingConfiguration)this.requestLoggingConfiguration).newBuilder();
        builder.responseLoggingConfigurationBuilder = ((SdkResponseLoggingConfiguration)this.responseLoggingConfiguration).newBuilder();
        return builder;
    }

    public static class Builder {
        private io.apimatic.coreinterfaces.logger.Logger logger = null;
        private Level level;
        private boolean maskSensitiveHeaders = true;
        private SdkRequestLoggingConfiguration.Builder requestLoggingConfigurationBuilder = new SdkRequestLoggingConfiguration.Builder();
        private SdkResponseLoggingConfiguration.Builder responseLoggingConfigurationBuilder = new SdkResponseLoggingConfiguration.Builder();

        public Builder logger(Logger logger) {
            this.logger = new Slf4jLogger(logger);
            return this;
        }

        public Builder logger(io.apimatic.coreinterfaces.logger.Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        public Builder maskSensitiveHeaders(boolean maskSensitiveHeaders) {
            this.maskSensitiveHeaders = maskSensitiveHeaders;
            return this;
        }

        public Builder requestConfig(SdkRequestLoggingConfiguration.Builder builder) {
            this.requestLoggingConfigurationBuilder = builder;
            return this;
        }

        public Builder responseConfig(SdkResponseLoggingConfiguration.Builder builder) {
            this.responseLoggingConfigurationBuilder = builder;
            return this;
        }

        public Builder useDefaultLogger() {
            this.logger = new ConsoleLogger();
            return this;
        }

        public SdkLoggingConfiguration build() {
            SdkRequestLoggingConfiguration requestLoggingConfiguration = this.requestLoggingConfigurationBuilder.build();
            SdkResponseLoggingConfiguration responseLoggingConfiguration = this.responseLoggingConfigurationBuilder.build();
            return new SdkLoggingConfiguration(this.logger, this.level, this.maskSensitiveHeaders, requestLoggingConfiguration, responseLoggingConfiguration);
        }
    }
}

