/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.plugins.httpsecuritypolicy;

import io.apiman.gateway.engine.beans.ApiRequest;
import io.apiman.gateway.engine.beans.ApiResponse;
import io.apiman.gateway.engine.beans.util.HeaderMap;
import io.apiman.gateway.engine.policies.AbstractMappedPolicy;
import io.apiman.gateway.engine.policy.IPolicyChain;
import io.apiman.gateway.engine.policy.IPolicyContext;
import io.apiman.plugins.httpsecuritypolicy.beans.ContentSecurityPolicyBean;
import io.apiman.plugins.httpsecuritypolicy.beans.HttpSecurityBean;

public class HttpSecurityPolicy
extends AbstractMappedPolicy<HttpSecurityBean> {
    protected Class<HttpSecurityBean> getConfigurationClass() {
        return HttpSecurityBean.class;
    }

    protected void doApply(ApiRequest request, IPolicyContext context, HttpSecurityBean config, IPolicyChain<ApiRequest> chain) {
        chain.doApply((Object)request);
    }

    protected void doApply(ApiResponse response, IPolicyContext context, HttpSecurityBean config, IPolicyChain<ApiResponse> chain) {
        this.setSecurityHeaders(config, response.getHeaders());
        chain.doApply((Object)response);
    }

    private void setSecurityHeaders(HttpSecurityBean config, HeaderMap headers) {
        ContentSecurityPolicyBean policyBean;
        if (config.getHsts().getEnabled().booleanValue()) {
            headers.put("Strict-Transport-Security", config.getHsts().getHeaderValue());
        }
        if (config.getFrameOptions() != HttpSecurityBean.FrameOptions.DISABLED) {
            headers.put("X-Frame-Options", config.getFrameOptions().toString());
        }
        if (config.getXssProtection() != HttpSecurityBean.XssProtection.DISABLED) {
            headers.put("X-XSS-Protection", config.getXssProtection().toString());
        }
        if (config.getContentTypeOptions().booleanValue()) {
            headers.put("X-Content-Type-Options", "nosniff");
        }
        if ((policyBean = config.getContentSecurityPolicy()).getMode() != ContentSecurityPolicyBean.Mode.DISABLED) {
            if (policyBean.getMode() == ContentSecurityPolicyBean.Mode.ENABLED) {
                headers.put("Content-Security-Policy", policyBean.getCsp());
            }
            if (policyBean.getMode() == ContentSecurityPolicyBean.Mode.REPORT_ONLY) {
                headers.put("Content-Security-Policy-Report-Only", policyBean.getCsp());
            }
        }
    }
}

